/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.mob;

import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.entity.ai.EntityAIAttackRangedBow;
import WayofTime.bloodmagic.entity.ai.EntityAIFollowOwner;
import WayofTime.bloodmagic.entity.ai.EntityAIGrabEffectsFromOwner;
import WayofTime.bloodmagic.entity.ai.EntityAIHurtByTargetIgnoreTamed;
import WayofTime.bloodmagic.entity.ai.EntityAIOwnerHurtByTarget;
import WayofTime.bloodmagic.entity.ai.EntityAIOwnerHurtTarget;
import WayofTime.bloodmagic.entity.ai.EntityAIRetreatToHeal;
import WayofTime.bloodmagic.entity.mob.EntityDemonBase;
import WayofTime.bloodmagic.item.soul.ItemSentientBow;
import WayofTime.bloodmagic.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntitySentientSpecter
extends EntityDemonBase {
    protected EnumDemonWillType type = EnumDemonWillType.DESTRUCTIVE;
    protected boolean wasGivenSentientArmour = false;
    private final EntityAIAttackRangedBow aiArrowAttack = new EntityAIAttackRangedBow(this, 1.0, 20, 15.0f);
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
    private final int attackPriority = 3;

    public EntitySentientSpecter(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, new EntityAIRetreatToHeal<EntityCreature>(this, EntityCreature.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIGrabEffectsFromOwner(this, 2.0, 1.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHurtByTargetIgnoreTamed(this, false, new Class[0]));
        this.setCombatTask();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27);
    }

    @Override
    public void setCombatTask() {
        if (this.func_130014_f_() != null && !this.func_130014_f_().field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemBow) {
                int i = 20;
                if (this.func_130014_f_().func_175659_aa() != EnumDifficulty.HARD) {
                    i = 40;
                }
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    @Override
    public boolean func_70687_e(PotionEffect effect) {
        Potion potion = effect.func_188419_a();
        if (potion == MobEffects.field_76428_l || potion == MobEffects.field_76432_h) {
            return false;
        }
        return super.func_70687_e(effect);
    }

    public boolean canStealEffectFromOwner(EntityLivingBase owner, PotionEffect effect) {
        return effect.func_188419_a().func_76398_f() && this.type == EnumDemonWillType.CORROSIVE;
    }

    public boolean canStealEffectFromOwner(EntityLivingBase owner) {
        if (this.type != EnumDemonWillType.CORROSIVE) {
            return false;
        }
        for (PotionEffect eff : owner.func_70651_bq()) {
            if (!this.canStealEffectFromOwner(owner, eff)) continue;
            return true;
        }
        return false;
    }

    public boolean stealEffectsFromOwner(EntityLivingBase owner) {
        if (this.type != EnumDemonWillType.CORROSIVE) {
            return false;
        }
        boolean hasStolenEffect = false;
        ArrayList<PotionEffect> removedEffects = new ArrayList<PotionEffect>();
        for (PotionEffect eff : owner.func_70651_bq()) {
            if (!this.canStealEffectFromOwner(owner, eff)) continue;
            removedEffects.add(eff);
            hasStolenEffect = true;
        }
        for (PotionEffect eff : removedEffects) {
            owner.func_184589_d(eff.func_188419_a());
            this.func_70690_d(eff);
        }
        return hasStolenEffect;
    }

    public boolean applyNegativeEffectsToAttacked(EntityLivingBase attackedEntity, float percentTransmitted) {
        PotionEffect activeEffect;
        boolean hasProvidedEffect = false;
        ArrayList<PotionEffect> removedEffects = new ArrayList<PotionEffect>();
        for (PotionEffect eff : this.func_70651_bq()) {
            if (!eff.func_188419_a().func_76398_f() || !attackedEntity.func_70687_e(eff)) continue;
            if (!attackedEntity.func_70644_a(eff.func_188419_a())) {
                removedEffects.add(eff);
                hasProvidedEffect = true;
                continue;
            }
            activeEffect = attackedEntity.func_70660_b(eff.func_188419_a());
            if (activeEffect.func_76458_c() >= eff.func_76458_c() && !((float)activeEffect.func_76459_b() < (float)eff.func_76459_b() * percentTransmitted)) continue;
            removedEffects.add(eff);
            hasProvidedEffect = true;
        }
        for (PotionEffect eff : removedEffects) {
            if (!attackedEntity.func_70644_a(eff.func_188419_a())) {
                PotionEffect newEffect = new PotionEffect(eff.func_188419_a(), (int)((float)eff.func_76459_b() * percentTransmitted), eff.func_76458_c(), eff.func_82720_e(), eff.func_188418_e());
                attackedEntity.func_70690_d(newEffect);
                PotionEffect newSentientEffect = new PotionEffect(eff.func_188419_a(), (int)((float)eff.func_76459_b() * (1.0f - percentTransmitted)), eff.func_76458_c(), eff.func_82720_e(), eff.func_188418_e());
                this.func_184589_d(eff.func_188419_a());
                this.func_70690_d(newSentientEffect);
                continue;
            }
            activeEffect = attackedEntity.func_70660_b(eff.func_188419_a());
            PotionEffect newEffect = new PotionEffect(eff.func_188419_a(), (int)((float)eff.func_76459_b() * percentTransmitted), eff.func_76458_c(), activeEffect.func_82720_e(), activeEffect.func_188418_e());
            attackedEntity.func_70690_d(newEffect);
            PotionEffect newSentientEffect = new PotionEffect(eff.func_188419_a(), (int)((float)eff.func_76459_b() * (1.0f - percentTransmitted)), eff.func_76458_c(), eff.func_82720_e(), eff.func_188418_e());
            this.func_184589_d(eff.func_188419_a());
            this.func_70690_d(newSentientEffect);
        }
        return hasProvidedEffect;
    }

    public List<PotionEffect> getPotionEffectsForArrowRemovingDuration(float percentTransmitted) {
        ArrayList<PotionEffect> arrowEffects = new ArrayList<PotionEffect>();
        if (this.type != EnumDemonWillType.CORROSIVE) {
            return arrowEffects;
        }
        ArrayList<PotionEffect> removedEffects = new ArrayList<PotionEffect>();
        for (PotionEffect eff : this.func_70651_bq()) {
            if (!eff.func_188419_a().func_76398_f()) continue;
            removedEffects.add(eff);
        }
        for (PotionEffect eff : removedEffects) {
            PotionEffect newEffect = new PotionEffect(eff.func_188419_a(), (int)((float)eff.func_76459_b() * percentTransmitted), eff.func_76458_c(), eff.func_82720_e(), eff.func_188418_e());
            arrowEffects.add(newEffect);
            PotionEffect newSentientEffect = new PotionEffect(eff.func_188419_a(), (int)((float)eff.func_76459_b() * (1.0f - percentTransmitted)), eff.func_76458_c(), eff.func_82720_e(), eff.func_188418_e());
            this.func_184589_d(eff.func_188419_a());
            this.func_70690_d(newSentientEffect);
        }
        return arrowEffects;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70652_k(Entity attackedEntity) {
        boolean flag = super.func_70652_k(attackedEntity);
        if (flag) {
            if (this.type == EnumDemonWillType.CORROSIVE && attackedEntity instanceof EntityLivingBase) {
                this.applyNegativeEffectsToAttacked((EntityLivingBase)attackedEntity, 1.0f);
            }
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.func_130014_f_().field_72995_K && this.func_184614_ca() != null) {
            this.func_70099_a(this.func_184614_ca(), 0.0f);
        }
    }

    @Override
    public boolean isStationary() {
        return false;
    }

    @Override
    public boolean absorbExplosion(Explosion explosion) {
        if (this.type == EnumDemonWillType.DESTRUCTIVE) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 600, 1));
            explosion.func_77279_a(true);
            return true;
        }
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (this.isTamed() && player.equals((Object)this.getOwner()) && hand == EnumHand.MAIN_HAND && stack == null && player.func_70093_af() && !this.func_130014_f_().field_72995_K) {
            if (this.func_184614_ca() != null) {
                this.func_70099_a(this.func_184614_ca(), 0.0f);
            }
            if (this.func_184592_cb() != null) {
                this.func_70099_a(this.func_184592_cb(), 0.0f);
            }
            if (this.wasGivenSentientArmour) {
                this.func_70099_a(new ItemStack(ModItems.SENTIENT_ARMOUR_GEM), 0.0f);
            }
            this.func_70106_y();
        }
        return super.func_184645_a(player, hand, stack);
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) && this.type == EnumDemonWillType.DESTRUCTIVE && source.func_94541_c();
    }

    @Override
    public void performEmergencyHeal(double toHeal) {
        this.func_70691_i((float)toHeal);
        if (this.func_130014_f_() instanceof WorldServer) {
            WorldServer server = (WorldServer)this.func_130014_f_();
            server.func_175739_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 7, 0.2, 0.2, 0.2, 0.0, new int[0]);
        }
    }

    public double absorbWillFromAuraToHeal(double toHeal) {
        if (this.func_130014_f_().field_72995_K) {
            return 0.0;
        }
        double healthMissing = this.func_110138_aP() - this.func_110143_aJ();
        if (healthMissing <= 0.0) {
            return 0.0;
        }
        double will = WorldDemonWillHandler.getCurrentWill(this.func_130014_f_(), this.func_180425_c(), this.getType());
        if ((toHeal = Math.min(healthMissing, Math.min(toHeal, will / this.getWillToHealth()))) > 0.0) {
            this.func_70691_i((float)toHeal);
            return WorldDemonWillHandler.drainWill(this.func_130014_f_(), this.func_180425_c(), this.getType(), toHeal * this.getWillToHealth(), true);
        }
        return 0.0;
    }

    public double getWillToHealth() {
        return 2.0;
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.isTamed() && super.func_70692_ba();
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K && this.field_70173_aa % 20 == 0) {
            this.absorbWillFromAuraToHeal(2.0);
        }
        super.func_70071_h_();
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74778_a("demonWillType", this.type.toString());
        tag.func_74757_a("sentientArmour", this.wasGivenSentientArmour);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.type = !tag.func_74764_b("demonWillType") ? EnumDemonWillType.DEFAULT : EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH));
        this.wasGivenSentientArmour = tag.func_74767_n("sentientArmour");
        this.setCombatTask();
    }

    @Override
    public boolean shouldAttackEntity(EntityLivingBase attacker, EntityLivingBase owner) {
        if (!(attacker instanceof EntityCreeper) && !(attacker instanceof EntityGhast)) {
            return super.shouldAttackEntity(attacker, owner);
        }
        return false;
    }

    @Override
    public void attackEntityWithRangedAttack(EntityLivingBase target, float velocity) {
        ItemStack heldStack = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (heldStack != null && heldStack.func_77973_b() == ModItems.SENTIENT_BOW) {
            EntityTippedArrow arrowEntity = ((ItemSentientBow)heldStack.func_77973_b()).getArrowEntity(this.func_130014_f_(), heldStack, target, (EntityLivingBase)this, velocity);
            if (arrowEntity != null) {
                List<PotionEffect> effects = this.getPotionEffectsForArrowRemovingDuration(0.2f);
                for (PotionEffect eff : effects) {
                    arrowEntity.func_184558_a(eff);
                }
                this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.func_130014_f_().func_72838_d((Entity)arrowEntity);
            }
        } else {
            boolean burning;
            EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.func_130014_f_(), (EntityLivingBase)this);
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entitytippedarrow.field_70163_u;
            double d2 = target.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            entitytippedarrow.func_70186_c(d0, d1 + d3 * 0.2, d2, 1.6f, 0.0f);
            int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
            int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
            entitytippedarrow.func_70239_b((double)(velocity * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.func_130014_f_().func_175659_aa().func_151525_a() * 0.11f));
            if (i > 0) {
                entitytippedarrow.func_70239_b(entitytippedarrow.func_70242_d() + (double)i * 0.5 + 0.5);
            }
            if (j > 0) {
                entitytippedarrow.func_70240_a(j);
            }
            boolean bl = burning = (burning = this.func_70027_ad()) || EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this) > 0;
            if (burning) {
                entitytippedarrow.func_70015_d(100);
            }
            entitytippedarrow.func_184558_a(new PotionEffect(MobEffects.field_76421_d, 600));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_72838_d((Entity)entitytippedarrow);
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187558_ak;
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187562_am;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187560_al;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    @Override
    protected float func_70599_aP() {
        return 0.4f;
    }

    public EnumDemonWillType getType() {
        return this.type;
    }

    public void setType(EnumDemonWillType type) {
        this.type = type;
    }

    public boolean isWasGivenSentientArmour() {
        return this.wasGivenSentientArmour;
    }

    public void setWasGivenSentientArmour(boolean wasGivenSentientArmour) {
        this.wasGivenSentientArmour = wasGivenSentientArmour;
    }
}

