/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.util.helper;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.api.altar.IBloodAltar;
import WayofTime.bloodmagic.api.event.SacrificeKnifeUsedEvent;
import WayofTime.bloodmagic.api.util.helper.IncenseHelper;
import WayofTime.bloodmagic.registry.ModPotions;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PlayerSacrificeHelper {
    public static float scalingOfSacrifice = 1.0f;
    public static int soulFrayDuration = 400;
    public static Potion soulFrayId;

    public static double getPlayerIncense(EntityPlayer player) {
        return IncenseHelper.getCurrentIncense(player);
    }

    public static void setPlayerIncense(EntityPlayer player, double amount) {
        IncenseHelper.setCurrentIncense(player, amount);
    }

    public static boolean incrementIncense(EntityPlayer player, double min, double incenseAddition, double increment) {
        double amount = PlayerSacrificeHelper.getPlayerIncense(player);
        if (amount < min || amount >= incenseAddition) {
            return false;
        }
        amount += Math.min(increment, incenseAddition - amount);
        PlayerSacrificeHelper.setPlayerIncense(player, amount);
        return true;
    }

    public static boolean sacrificePlayerHealth(EntityPlayer player) {
        float maxHealth;
        float health;
        if (player.func_70644_a(soulFrayId)) {
            return false;
        }
        double amount = PlayerSacrificeHelper.getPlayerIncense(player);
        if (amount >= 0.0 && (double)(health = player.func_110143_aJ()) > (double)(maxHealth = player.func_110138_aP()) / 10.0) {
            float sacrificedHealth = health - maxHealth / 10.0f;
            int lpAdded = (int)((double)(sacrificedHealth * (float)ConfigHandler.sacrificialDaggerConversion) * PlayerSacrificeHelper.getModifier(amount));
            SacrificeKnifeUsedEvent evt = new SacrificeKnifeUsedEvent(player, true, true, (int)sacrificedHealth, lpAdded);
            if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
                return false;
            }
            if (PlayerSacrificeHelper.findAndFillAltar(player.func_130014_f_(), (EntityLivingBase)player, evt.lpAdded, false)) {
                player.func_70606_j(maxHealth / 10.0f);
                PlayerSacrificeHelper.setPlayerIncense(player, 0.0);
                player.func_70690_d(new PotionEffect(ModPotions.soulFray, soulFrayDuration));
                return true;
            }
        }
        return false;
    }

    public static double getModifier(double amount) {
        return 1.0 + amount * (double)scalingOfSacrifice;
    }

    public static boolean findAndFillAltar(World world, EntityLivingBase sacrificingEntity, int amount, boolean isSacrifice) {
        IBloodAltar altarEntity = PlayerSacrificeHelper.getAltar(world, sacrificingEntity.func_180425_c());
        if (altarEntity == null) {
            return false;
        }
        altarEntity.sacrificialDaggerCall(amount, isSacrifice);
        altarEntity.startCycle();
        return true;
    }

    public static IBloodAltar getAltar(World world, BlockPos blockPos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    TileEntity tileEntity = world.func_175625_s(blockPos.func_177982_a(x, y, z));
                    if (!(tileEntity instanceof IBloodAltar)) continue;
                    return (IBloodAltar)tileEntity;
                }
            }
        }
        return null;
    }
}

