/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class AlchemyTableRecipe {
    protected ItemStack output = null;
    protected ArrayList<Object> input = new ArrayList();
    protected int lpDrained;
    protected int ticksRequired;
    protected int tierRequired;

    public AlchemyTableRecipe(Block result, int lpDrained, int ticksRequired, int tierRequired, Object ... recipe) {
        this(new ItemStack(result), lpDrained, ticksRequired, tierRequired, recipe);
    }

    public AlchemyTableRecipe(Item result, int lpDrained, int ticksRequired, int tierRequired, Object ... recipe) {
        this(new ItemStack(result), lpDrained, ticksRequired, tierRequired, recipe);
    }

    public AlchemyTableRecipe(ItemStack result, int lpDrained, int ticksRequired, int tierRequired, Object ... recipe) {
        this.output = result.func_77946_l();
        this.lpDrained = lpDrained;
        this.ticksRequired = ticksRequired;
        this.tierRequired = tierRequired;
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid alchemy recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public ItemStack getRecipeOutput(List<ItemStack> inputList) {
        return this.output.func_77946_l();
    }

    public boolean matches(List<ItemStack> checkedList, World world, BlockPos pos) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (int x = 0; x < checkedList.size(); ++x) {
            ItemStack slot = checkedList.get(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<Object> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }

    public ItemStack[] getRemainingItems(ItemStack[] inventory) {
        ItemStack[] ret = (ItemStack[])inventory.clone();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getContainerItem(inventory[i]);
        }
        return ret;
    }

    protected ItemStack getContainerItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStack copyStack = stack.func_77946_l();
        if (copyStack.func_77973_b().hasContainerItem(stack)) {
            return copyStack.func_77973_b().getContainerItem(copyStack);
        }
        --copyStack.field_77994_a;
        if (copyStack.field_77994_a <= 0) {
            return null;
        }
        return copyStack;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlchemyTableRecipe)) {
            return false;
        }
        AlchemyTableRecipe other = (AlchemyTableRecipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ItemStack this$output = this.output;
        ItemStack other$output = other.output;
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        ArrayList<Object> this$input = this.getInput();
        ArrayList<Object> other$input = other.getInput();
        if (this$input == null ? other$input != null : !((Object)this$input).equals(other$input)) {
            return false;
        }
        if (this.getLpDrained() != other.getLpDrained()) {
            return false;
        }
        if (this.getTicksRequired() != other.getTicksRequired()) {
            return false;
        }
        return this.getTierRequired() == other.getTierRequired();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlchemyTableRecipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ItemStack $output = this.output;
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        ArrayList<Object> $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
        result = result * 59 + this.getLpDrained();
        result = result * 59 + this.getTicksRequired();
        result = result * 59 + this.getTierRequired();
        return result;
    }

    public String toString() {
        return "AlchemyTableRecipe(output=" + this.output + ", input=" + this.getInput() + ", lpDrained=" + this.getLpDrained() + ", ticksRequired=" + this.getTicksRequired() + ", tierRequired=" + this.getTierRequired() + ")";
    }

    public int getLpDrained() {
        return this.lpDrained;
    }

    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public int getTierRequired() {
        return this.tierRequired;
    }
}

