/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.handler.event;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.annot.Handler;
import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.event.ItemBindEvent;
import WayofTime.bloodmagic.api.event.SacrificeKnifeUsedEvent;
import WayofTime.bloodmagic.api.event.TeleposeEvent;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.iface.ISentientTool;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.orb.IBloodOrb;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.soul.DemonWillHolder;
import WayofTime.bloodmagic.api.util.helper.BindableHelper;
import WayofTime.bloodmagic.api.util.helper.ItemHelper;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.block.BlockAltar;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.entity.mob.EntitySentientSpecter;
import WayofTime.bloodmagic.item.ItemAltarMaker;
import WayofTime.bloodmagic.item.ItemExperienceBook;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.item.gear.ItemPackSacrifice;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeBattleHungry;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerSelfSacrifice;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeSelfSacrifice;
import WayofTime.bloodmagic.network.BloodMagicPacketHandler;
import WayofTime.bloodmagic.network.DemonAuraPacketProcessor;
import WayofTime.bloodmagic.potion.BMPotionUtils;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.registry.ModPotions;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Handler
public class GenericHandler {
    public static Map<EntityPlayer, Double> bounceMap = new HashMap<EntityPlayer, Double>();
    public static Map<EntityPlayer, Integer> filledHandMap = new HashMap<EntityPlayer, Integer>();
    private static Map<EntityAnimal, EntityAITarget> targetTaskMap = new HashMap<EntityAnimal, EntityAITarget>();
    private static Map<EntityAnimal, EntityAIBase> attackTaskMap = new HashMap<EntityAnimal, EntityAIBase>();

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).func_70644_a(ModPotions.bounce) && !player.func_70093_af() && event.getDistance() > 2.0f) {
            event.setDamageMultiplier(0.0f);
            if (player.func_130014_f_().field_72995_K) {
                player.field_70181_x *= -0.9;
                player.field_70143_R = 0.0f;
                bounceMap.put(player, player.field_70181_x);
            } else {
                player.field_70143_R = 0.0f;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void playerTickPost(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && bounceMap.containsKey(event.player)) {
            event.player.field_70181_x = bounceMap.remove(event.player);
        }
        if (event.phase == TickEvent.Phase.END && filledHandMap.containsKey(event.player)) {
            int value = filledHandMap.get(event.player) - 1;
            if (value <= 0) {
                filledHandMap.remove(event.player);
            } else {
                filledHandMap.put(event.player, value);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClick(PlayerInteractEvent event) {
        if (event.isCancelable() && event.getEntityPlayer().func_70644_a(ModPotions.constrict)) {
            EntityPlayer player = event.getEntityPlayer();
            int level = player.func_70660_b(ModPotions.constrict).func_76458_c();
            if (event.getHand() == EnumHand.OFF_HAND || level > 1) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDropItem(ItemTossEvent event) {
        EntityItem itemEntity = event.getEntityItem();
        if (itemEntity != null) {
            ItemStack stack = itemEntity.func_92059_d();
            Item item = stack.func_77973_b();
            if (stack.func_77942_o() && item instanceof ISentientTool && ((ISentientTool)item).spawnSentientEntityOnDrop(stack, event.getPlayer())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        World world = event.getWorld();
        Explosion exp = event.getExplosion();
        Vec3d position = exp.getPosition();
        double radius = 3.0;
        AxisAlignedBB bb = new AxisAlignedBB(position.field_72450_a - radius, position.field_72448_b - radius, position.field_72449_c - radius, position.field_72450_a + radius, position.field_72448_b + radius, position.field_72449_c + radius);
        List specterList = world.func_72872_a(EntitySentientSpecter.class, bb);
        if (!specterList.isEmpty()) {
            for (EntitySentientSpecter specter : specterList) {
                if (!specter.absorbExplosion(exp)) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !PlayerHelper.isFakePlayer((EntityPlayer)event.getSource().func_76346_g())) {
            LivingArmourUpgrade upgrade;
            ItemStack chestStack;
            LivingArmour armour;
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (!player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemPackSacrifice) {
                ItemPackSacrifice pack = (ItemPackSacrifice)player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b();
                boolean shouldSyphon = pack.getStoredLP(player.func_184582_a(EntityEquipmentSlot.CHEST)) < pack.CAPACITY;
                float damageDone = event.getEntityLiving().func_110143_aJ() < event.getAmount() ? event.getAmount() - event.getEntityLiving().func_110143_aJ() : event.getAmount();
                int totalLP = Math.round(damageDone * (float)ConfigHandler.sacrificialPackConversion);
                if (shouldSyphon) {
                    ItemHelper.LPContainer.addLPToItem(player.func_184582_a(EntityEquipmentSlot.CHEST), totalLP, pack.CAPACITY);
                }
            }
            if (LivingArmour.hasFullSet(player) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null && (upgrade = ItemLivingArmour.getUpgrade("bloodmagic.upgrade.battleHunger", chestStack)) instanceof LivingArmourUpgradeBattleHungry) {
                ((LivingArmourUpgradeBattleHungry)upgrade).resetTimer();
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        int duration;
        EntityPlayer player;
        EntityLivingBase entity;
        if (!event.getEntityLiving().func_130014_f_().field_72995_K) {
            entity = event.getEntityLiving();
            if (entity instanceof EntityPlayer && entity.field_70173_aa % 50 == 0) {
                this.sendPlayerDemonWillAura((EntityPlayer)entity);
            }
            if (event.getEntityLiving() instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)event.getEntityLiving();
                if (animal.func_70644_a(ModPotions.sacrificialLamb)) {
                    if (!targetTaskMap.containsKey(animal)) {
                        EntityAINearestAttackableTarget task = new EntityAINearestAttackableTarget((EntityCreature)animal, EntityMob.class, false);
                        EntityAIAttackMelee attackTask = new EntityAIAttackMelee((EntityCreature)animal, 1.0, false);
                        animal.field_70715_bh.func_75776_a(1, (EntityAIBase)task);
                        animal.field_70714_bg.func_75776_a(1, (EntityAIBase)attackTask);
                        targetTaskMap.put(animal, (EntityAITarget)task);
                        attackTaskMap.put(animal, (EntityAIBase)attackTask);
                    }
                    if (animal.func_70638_az() != null && animal.func_70068_e((Entity)animal.func_70638_az()) < 4.0) {
                        animal.func_130014_f_().func_72876_a(null, animal.field_70165_t, animal.field_70163_u + (double)(animal.field_70131_O / 16.0f), animal.field_70161_v, 2.0f + (float)animal.func_70660_b(ModPotions.sacrificialLamb).func_76458_c() * 1.5f, false);
                        targetTaskMap.remove(animal);
                        attackTaskMap.remove(animal);
                    }
                } else if (targetTaskMap.containsKey(animal)) {
                    targetTaskMap.remove(animal);
                    attackTaskMap.remove(animal);
                }
            }
        }
        if ((entity = event.getEntityLiving()) instanceof EntityPlayer && (player = (EntityPlayer)entity).func_70093_af() && player.func_70644_a(ModPotions.cling) && Utils.isPlayerBesideSolidBlockFace(player) && !player.field_70122_E) {
            if (player.func_130014_f_().field_72995_K) {
                player.field_70181_x = 0.0;
                player.field_70159_w *= 0.8;
                player.field_70179_y *= 0.8;
            } else {
                player.field_70143_R = 0.0f;
            }
        }
        if (entity.func_70644_a(MobEffects.field_76439_r) && (duration = entity.func_70660_b(MobEffects.field_76439_r).func_76459_b()) == 30000) {
            entity.func_184589_d(MobEffects.field_76439_r);
        }
        if (entity.func_70644_a(ModPotions.fireFuse)) {
            Random random = entity.func_130014_f_().field_73012_v;
            entity.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, entity.field_70165_t + random.nextDouble() * 0.3, entity.field_70163_u + random.nextDouble() * 0.3, entity.field_70161_v + random.nextDouble() * 0.3, 0.0, 0.06, 0.0, new int[0]);
            int r = entity.func_70660_b(ModPotions.fireFuse).func_76458_c();
            int radius = 1 * r + 1;
            if (entity.func_70660_b(ModPotions.fireFuse).func_76459_b() <= 3) {
                entity.func_130014_f_().func_72876_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (float)radius, false);
            }
        }
        if (entity.func_70644_a(ModPotions.plantLeech)) {
            int amplifier = entity.func_70660_b(ModPotions.plantLeech).func_76458_c();
            int timeRemaining = entity.func_70660_b(ModPotions.plantLeech).func_76459_b();
            if (timeRemaining % 10 == 0) {
                BMPotionUtils.damageMobAndGrowSurroundingPlants(entity, 2 + amplifier, 1, 1.5 / (double)(amplifier + 3), 25 * (1 + amplifier));
            }
        }
    }

    public void sendPlayerDemonWillAura(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            BlockPos pos = player.func_180425_c();
            DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(player.func_130014_f_().field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            if (holder != null) {
                BloodMagicPacketHandler.sendTo(new DemonAuraPacketProcessor(holder), (EntityPlayerMP)player);
            } else {
                BloodMagicPacketHandler.sendTo(new DemonAuraPacketProcessor(new DemonWillHolder()), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public void harvestEvent(PlayerEvent.HarvestCheck event) {
        IBlockState state = event.getTargetBlock();
        Block block = state.func_177230_c();
        if (block instanceof BlockAltar && event.getEntityPlayer() != null && event.getEntityPlayer() instanceof EntityPlayerMP && !event.getEntityPlayer().func_184614_ca().func_190926_b() && event.getEntityPlayer().func_184614_ca().func_77973_b() instanceof ItemAltarMaker) {
            ItemAltarMaker altarMaker = (ItemAltarMaker)event.getEntityPlayer().func_184614_ca().func_77973_b();
            ChatUtil.sendNoSpam(event.getEntityPlayer(), TextHelper.localizeEffect("chat.bloodmagic.altarMaker.destroy", altarMaker.destroyAltar(event.getEntityPlayer())));
        }
    }

    @SubscribeEvent
    public void onTelepose(TeleposeEvent event) {
        if (ConfigHandler.teleposerBlacklist.contains(event.initialStack) || ConfigHandler.teleposerBlacklist.contains(event.finalStack)) {
            event.setCanceled(true);
        }
        if (BloodMagicAPI.getTeleposerBlacklist().contains(event.initialStack) || BloodMagicAPI.getTeleposerBlacklist().contains(event.finalStack)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTeleposeEntity(TeleposeEvent.Ent event) {
        if (ConfigHandler.teleposerBlacklistEntity.contains(event.entity.getClass().getSimpleName())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTeleposeEntityPost(TeleposeEvent.Ent.Post event) {
        event.entity.field_71088_bW = 5;
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickItem event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (PlayerHelper.isFakePlayer(player)) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (!held.func_190926_b() && held.func_77973_b() instanceof IBindable) {
            IBindable bindable = (IBindable)(held = NBTHelper.checkNBT(held)).func_77973_b();
            if (Strings.isNullOrEmpty((String)bindable.getOwnerUUID(held))) {
                if (bindable.onBind(player, held)) {
                    String uuid = PlayerHelper.getUUIDFromPlayer(player).toString();
                    ItemBindEvent toPost = new ItemBindEvent(player, uuid, held);
                    if (MinecraftForge.EVENT_BUS.post((Event)toPost) || toPost.getResult() == Event.Result.DENY) {
                        return;
                    }
                    BindableHelper.setItemOwnerUUID(held, uuid);
                    BindableHelper.setItemOwnerName(held, player.getDisplayNameString());
                }
            } else if (bindable.getOwnerUUID(held).equals(PlayerHelper.getUUIDFromPlayer(player).toString()) && !bindable.getOwnerName(held).equals(player.getDisplayNameString())) {
                BindableHelper.setItemOwnerName(held, player.getDisplayNameString());
            }
        }
        if (!held.func_190926_b() && held.func_77973_b() instanceof IBloodOrb) {
            held = NBTHelper.checkNBT(held);
            IBloodOrb bloodOrb = (IBloodOrb)held.func_77973_b();
            SoulNetwork network = NetworkHelper.getSoulNetwork(player);
            if (bloodOrb.getOrbLevel(held.func_77952_i()) > network.getOrbTier()) {
                network.setOrbTier(bloodOrb.getOrbLevel(held.func_77952_i()));
            }
        }
    }

    @SubscribeEvent
    public void selfSacrificeEvent(SacrificeKnifeUsedEvent event) {
        ItemStack chestStack;
        LivingArmour armour;
        EntityPlayer player = event.player;
        if (LivingArmour.hasFullSet(player) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null) {
            StatTrackerSelfSacrifice.incrementCounter(armour, event.healthDrained / 2);
            LivingArmourUpgrade upgrade = ItemLivingArmour.getUpgrade("bloodmagic.upgrade.selfSacrifice", chestStack);
            if (upgrade instanceof LivingArmourUpgradeSelfSacrifice) {
                double modifier = ((LivingArmourUpgradeSelfSacrifice)upgrade).getSacrificeModifier();
                event.lpAdded = (int)((double)event.lpAdded * (1.0 + modifier));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EntityPlayer player;
        ItemStack heldStack;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity entity = source.func_76346_g();
        if (entity != null && entity instanceof EntityPlayer && !(heldStack = (player = (EntityPlayer)entity).func_184614_ca()).func_190926_b() && heldStack.func_77973_b() == ModItems.BOUND_SWORD && !(attackedEntity instanceof EntityAnimal)) {
            for (int i = 0; i <= EnchantmentHelper.func_185283_h((EntityLivingBase)player); ++i) {
                if (!(attackedEntity.func_130014_f_().field_73012_v.nextDouble() < 0.2)) continue;
                event.getDrops().add(new EntityItem(attackedEntity.func_130014_f_(), attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, new ItemStack(ModItems.BLOOD_SHARD, 1, 0)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onExperiencePickup(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack itemstack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)player);
        if (!itemstack.func_190926_b() && itemstack.func_77951_h()) {
            int i = Math.min(this.xpToDurability(event.getOrb().field_70530_e), itemstack.func_77952_i());
            event.getOrb().field_70530_e -= this.durabilityToXp(i);
            itemstack.func_77964_b(itemstack.func_77952_i() - i);
        }
        if (!player.func_130014_f_().field_72995_K) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (!(stack.func_77973_b() instanceof ItemExperienceBook)) continue;
                ItemExperienceBook.addExperience(stack, event.getOrb().field_70530_e);
                event.getOrb().field_70530_e = 0;
                break;
            }
        }
    }

    private int xpToDurability(int xp) {
        return xp * 2;
    }

    private int durabilityToXp(int durability) {
        return durability / 2;
    }
}

