/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.api.recipe.TartaricForgeRecipe;
import WayofTime.bloodmagic.api.registry.TartaricForgeRecipeRegistry;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDemonWill;
import WayofTime.bloodmagic.api.soul.IDemonWillConduit;
import WayofTime.bloodmagic.api.soul.IDemonWillGem;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.tile.TileInventory;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileSoulForge
extends TileInventory
implements ITickable,
IDemonWillConduit {
    public static final int ticksRequired = 100;
    public static final double worldWillTransferRate = 1.0;
    public static final int soulSlot = 4;
    public static final int outputSlot = 5;
    public int burnTime = 0;

    public TileSoulForge() {
        super(6, "soulForge");
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.burnTime = tag.func_74762_e("burnTime");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74768_a("burnTime", this.burnTime);
        return tag;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            for (EnumDemonWillType type : EnumDemonWillType.values()) {
                double willInWorld = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, type);
                double filled = Math.min(willInWorld, 1.0);
                if (!(filled > 0.0)) continue;
                filled = this.fillDemonWill(type, filled, false);
                filled = WorldDemonWillHandler.drainWill(this.func_145831_w(), this.field_174879_c, type, filled, false);
                if (!(filled > 0.0)) continue;
                this.fillDemonWill(type, filled, true);
                WorldDemonWillHandler.drainWill(this.func_145831_w(), this.field_174879_c, type, filled, true);
            }
        }
        if (!this.hasSoulGemOrSoul()) {
            this.burnTime = 0;
            return;
        }
        double soulsInGem = this.getWill(EnumDemonWillType.DEFAULT);
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            inputList.add(this.func_70301_a(i));
        }
        TartaricForgeRecipe recipe = TartaricForgeRecipeRegistry.getMatchingRecipe(inputList, this.func_145831_w(), this.func_174877_v());
        if (recipe != null && (soulsInGem >= recipe.getMinimumSouls() || this.burnTime > 0)) {
            if (this.canCraft(recipe)) {
                ++this.burnTime;
                if (this.burnTime == 100) {
                    if (!this.func_145831_w().field_72995_K) {
                        double requiredSouls = recipe.getSoulsDrained();
                        if (requiredSouls > 0.0 && !this.func_145831_w().field_72995_K && soulsInGem >= recipe.getMinimumSouls()) {
                            this.consumeSouls(EnumDemonWillType.DEFAULT, requiredSouls);
                        }
                        if (!this.func_145831_w().field_72995_K && soulsInGem >= recipe.getMinimumSouls()) {
                            this.craftItem(recipe);
                        }
                    }
                    this.burnTime = 0;
                } else if (this.burnTime > 110) {
                    this.burnTime = 0;
                }
            } else {
                this.burnTime = 0;
            }
        } else {
            this.burnTime = 0;
        }
    }

    public double getProgressForGui() {
        return (double)this.burnTime / 100.0;
    }

    private boolean canCraft(TartaricForgeRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack outputStack = recipe.getRecipeOutput();
        ItemStack currentOutputStack = this.func_70301_a(5);
        if (outputStack.func_190926_b()) {
            return false;
        }
        if (currentOutputStack.func_190926_b()) {
            return true;
        }
        if (!currentOutputStack.func_77969_a(outputStack)) {
            return false;
        }
        int result = currentOutputStack.func_190916_E() + outputStack.func_190916_E();
        return result <= this.func_70297_j_() && result <= currentOutputStack.func_77976_d();
    }

    public void craftItem(TartaricForgeRecipe recipe) {
        if (this.canCraft(recipe)) {
            ItemStack outputStack = recipe.getRecipeOutput();
            ItemStack currentOutputStack = this.func_70301_a(5);
            if (currentOutputStack.func_190926_b()) {
                this.func_70299_a(5, outputStack);
            } else if (currentOutputStack.func_77973_b() == currentOutputStack.func_77973_b()) {
                currentOutputStack.func_190917_f(outputStack.func_190916_E());
            }
            this.consumeInventory();
        }
    }

    public boolean hasSoulGemOrSoul() {
        ItemStack soulStack = this.func_70301_a(4);
        return !soulStack.func_190926_b() && (soulStack.func_77973_b() instanceof IDemonWill || soulStack.func_77973_b() instanceof IDemonWillGem);
    }

    public double getWill(EnumDemonWillType type) {
        ItemStack soulStack = this.func_70301_a(4);
        if (soulStack != null) {
            if (soulStack.func_77973_b() instanceof IDemonWill && ((IDemonWill)soulStack.func_77973_b()).getType(soulStack) == type) {
                IDemonWill soul = (IDemonWill)soulStack.func_77973_b();
                return soul.getWill(type, soulStack);
            }
            if (soulStack.func_77973_b() instanceof IDemonWillGem) {
                IDemonWillGem soul = (IDemonWillGem)soulStack.func_77973_b();
                return soul.getWill(type, soulStack);
            }
        }
        return 0.0;
    }

    public double consumeSouls(EnumDemonWillType type, double requested) {
        ItemStack soulStack = this.func_70301_a(4);
        if (soulStack != null) {
            if (soulStack.func_77973_b() instanceof IDemonWill && ((IDemonWill)soulStack.func_77973_b()).getType(soulStack) == type) {
                IDemonWill soul = (IDemonWill)soulStack.func_77973_b();
                double souls = soul.drainWill(type, soulStack, requested);
                if (soul.getWill(type, soulStack) <= 0.0) {
                    this.func_70299_a(4, ItemStack.field_190927_a);
                }
                return souls;
            }
            if (soulStack.func_77973_b() instanceof IDemonWillGem) {
                IDemonWillGem soul = (IDemonWillGem)soulStack.func_77973_b();
                return soul.drainWill(type, soulStack, requested, true);
            }
        }
        return 0.0;
    }

    public void consumeInventory() {
        for (int i = 0; i < 4; ++i) {
            ItemStack inputStack = this.func_70301_a(i);
            if (inputStack.func_190926_b()) continue;
            if (inputStack.func_77973_b().hasContainerItem(inputStack)) {
                this.func_70299_a(i, inputStack.func_77973_b().getContainerItem(inputStack));
                continue;
            }
            inputStack.func_190918_g(1);
            if (!inputStack.func_190926_b()) continue;
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public int getWeight() {
        return 50;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        ItemStack stack = this.func_70301_a(4);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IDemonWillGem)) {
            return 0.0;
        }
        IDemonWillGem willGem = (IDemonWillGem)stack.func_77973_b();
        return willGem.fillWill(type, stack, amount, doFill);
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        ItemStack stack = this.func_70301_a(4);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IDemonWillGem)) {
            return 0.0;
        }
        IDemonWillGem willGem = (IDemonWillGem)stack.func_77973_b();
        double drained = amount;
        double current = willGem.getWill(type, stack);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            drained = willGem.drainWill(type, stack, drained, true);
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return 0.0;
    }
}

