/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.api.event.RitualEvent;
import WayofTime.bloodmagic.api.registry.RitualRegistry;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.api.util.helper.RitualHelper;
import WayofTime.bloodmagic.item.ItemActivationCrystal;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.tile.base.TileTicking;
import WayofTime.bloodmagic.util.ChatUtil;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileMasterRitualStone
extends TileTicking
implements IMasterRitualStone {
    private String owner;
    private SoulNetwork cachedNetwork;
    private boolean active;
    private boolean redstoned;
    private int activeTime;
    private int cooldown;
    private Ritual currentRitual;
    private EnumFacing direction = EnumFacing.NORTH;
    private boolean inverted;
    private List<EnumDemonWillType> currentActiveWillConfig = new ArrayList<EnumDemonWillType>();

    @Override
    public void onUpdate() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.isPowered() && this.isActive()) {
            this.active = false;
            this.redstoned = true;
            this.stopRitual(Ritual.BreakType.REDSTONE);
            return;
        }
        if (!this.isActive() && !this.isPowered() && this.isRedstoned() && this.getCurrentRitual() != null) {
            this.active = true;
            ItemStack crystalStack = NBTHelper.checkNBT(new ItemStack(ModItems.ACTIVATION_CRYSTAL, 1, this.getCurrentRitual().getCrystalLevel()));
            crystalStack.func_77978_p().func_74778_a("ownerUUID", this.getOwner());
            this.activateRitual(crystalStack, null, this.getCurrentRitual());
            this.redstoned = false;
        }
        if (this.getCurrentRitual() != null && this.isActive()) {
            if (this.activeTime % this.getCurrentRitual().getRefreshTime() == 0) {
                this.performRitual(this.func_145831_w(), this.func_174877_v());
            }
            ++this.activeTime;
        }
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        NBTTagCompound ritualTag;
        this.owner = tag.func_74779_i("ownerUUID");
        if (!Strings.isNullOrEmpty((String)this.owner)) {
            this.cachedNetwork = NetworkHelper.getSoulNetwork(this.owner);
        }
        this.currentRitual = RitualRegistry.getRitualForId(tag.func_74779_i("currentRitual"));
        if (this.currentRitual != null && !(ritualTag = tag.func_74775_l("currentRitualTag")).func_82582_d()) {
            this.currentRitual.readFromNBT(ritualTag);
        }
        this.active = tag.func_74767_n("isRunning");
        this.activeTime = tag.func_74762_e("runtime");
        this.direction = EnumFacing.field_82609_l[tag.func_74762_e("direction")];
        this.redstoned = tag.func_74767_n("isStoned");
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            if (!tag.func_74767_n("EnumWill" + (Object)((Object)type))) continue;
            this.currentActiveWillConfig.add(type);
        }
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        String ritualId = RitualRegistry.getIdForRitual(this.getCurrentRitual());
        tag.func_74778_a("ownerUUID", Strings.isNullOrEmpty((String)this.getOwner()) ? "" : this.getOwner());
        tag.func_74778_a("currentRitual", Strings.isNullOrEmpty((String)ritualId) ? "" : ritualId);
        if (this.currentRitual != null) {
            NBTTagCompound ritualTag = new NBTTagCompound();
            this.currentRitual.writeToNBT(ritualTag);
            tag.func_74782_a("currentRitualTag", (NBTBase)ritualTag);
        }
        tag.func_74757_a("isRunning", this.isActive());
        tag.func_74768_a("runtime", this.getActiveTime());
        tag.func_74768_a("direction", this.direction.func_176745_a());
        tag.func_74757_a("isStoned", this.redstoned);
        for (EnumDemonWillType type : this.currentActiveWillConfig) {
            tag.func_74757_a("EnumWill" + (Object)((Object)type), true);
        }
        return tag;
    }

    @Override
    public boolean activateRitual(ItemStack activationCrystal, @Nullable EntityPlayer activator, Ritual ritual) {
        if (PlayerHelper.isFakePlayer(activator)) {
            return false;
        }
        String crystalOwner = (activationCrystal = NBTHelper.checkNBT(activationCrystal)).func_77978_p().func_74779_i("ownerUUID");
        if (!Strings.isNullOrEmpty((String)crystalOwner) && ritual != null) {
            int crystalLevel;
            if (activationCrystal.func_77973_b() instanceof ItemActivationCrystal && RitualHelper.canCrystalActivate(ritual, crystalLevel = ((ItemActivationCrystal)activationCrystal.func_77973_b()).getCrystalLevel(activationCrystal))) {
                if (!this.func_145831_w().field_72995_K) {
                    RitualEvent.RitualActivatedEvent event;
                    SoulNetwork network = NetworkHelper.getSoulNetwork(crystalOwner);
                    if (!this.isRedstoned() && network.getCurrentEssence() < ritual.getActivationCost() && activator != null && !activator.field_71075_bZ.field_75098_d) {
                        activator.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.ritual.weak", new Object[0]), true);
                        return false;
                    }
                    if (this.currentRitual != null) {
                        this.currentRitual.stopRitual(this, Ritual.BreakType.ACTIVATE);
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)(event = new RitualEvent.RitualActivatedEvent(this, crystalOwner, ritual, activator, activationCrystal, crystalLevel))) || event.getResult() == Event.Result.DENY) {
                        if (activator != null) {
                            activator.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.ritual.prevent", new Object[0]), true);
                        }
                        return false;
                    }
                    if (ritual.activateRitual(this, activator, crystalOwner)) {
                        if (!this.isRedstoned() && activator != null && !activator.field_71075_bZ.field_75098_d) {
                            network.syphon(ritual.getActivationCost());
                        }
                        if (activator != null) {
                            activator.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.ritual.activate", new Object[0]), true);
                        }
                        this.active = true;
                        this.owner = crystalOwner;
                        this.cachedNetwork = network;
                        this.currentRitual = ritual;
                        this.notifyUpdate();
                        return true;
                    }
                }
                this.notifyUpdate();
                return true;
            }
        } else if (activator != null) {
            activator.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.ritual.notValid", new Object[0]), true);
        }
        return false;
    }

    @Override
    public void performRitual(World world, BlockPos pos) {
        if (!world.field_72995_K && this.getCurrentRitual() != null && RitualRegistry.ritualEnabled(this.getCurrentRitual())) {
            if (RitualHelper.checkValidRitual(this.func_145831_w(), this.func_174877_v(), RitualRegistry.getIdForRitual(this.currentRitual), this.getDirection())) {
                RitualEvent.RitualRunEvent event = new RitualEvent.RitualRunEvent(this, this.getOwner(), this.getCurrentRitual());
                if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
                    return;
                }
                this.getCurrentRitual().performRitual(this);
            } else {
                this.stopRitual(Ritual.BreakType.BREAK_STONE);
            }
        }
    }

    @Override
    public void stopRitual(Ritual.BreakType breakType) {
        if (!this.func_145831_w().field_72995_K && this.getCurrentRitual() != null) {
            RitualEvent.RitualStopEvent event = new RitualEvent.RitualStopEvent((IMasterRitualStone)this, this.getOwner(), this.getCurrentRitual(), breakType);
            if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
                return;
            }
            this.getCurrentRitual().stopRitual(this, breakType);
            if (breakType != Ritual.BreakType.REDSTONE) {
                this.currentRitual = null;
                this.active = false;
                this.activeTime = 0;
            }
            this.notifyUpdate();
        }
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public EnumFacing getDirection() {
        return this.direction;
    }

    @Override
    public boolean areTanksEmpty() {
        return false;
    }

    @Override
    public int getRunningTime() {
        return this.activeTime;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public SoulNetwork getOwnerNetwork() {
        return this.cachedNetwork;
    }

    public World func_145831_w() {
        return super.func_145831_w();
    }

    public BlockPos func_174877_v() {
        return super.func_174877_v();
    }

    @Override
    public World getWorldObj() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public String getNextBlockRange(String range) {
        if (this.currentRitual != null) {
            return this.currentRitual.getNextBlockRange(range);
        }
        return "";
    }

    @Override
    public void provideInformationOfRitualToPlayer(EntityPlayer player) {
        if (this.currentRitual != null) {
            ChatUtil.sendNoSpam(player, this.currentRitual.provideInformationOfRitualToPlayer(player));
        }
    }

    @Override
    public void provideInformationOfRangeToPlayer(EntityPlayer player, String range) {
        if (this.currentRitual != null && this.currentRitual.getListOfRanges().contains(range)) {
            ChatUtil.sendNoSpam(player, this.currentRitual.provideInformationOfRangeToPlayer(player, range));
        }
    }

    @Override
    public void setActiveWillConfig(EntityPlayer player, List<EnumDemonWillType> typeList) {
        this.currentActiveWillConfig = typeList;
    }

    @Override
    public boolean setBlockRangeByBounds(EntityPlayer player, String range, BlockPos offset1, BlockPos offset2) {
        if (this.currentRitual != null) {
            boolean allowed = this.currentRitual.setBlockRangeByBounds(range, this, offset1, offset2);
            if (player != null && !allowed) {
                ChatUtil.sendNoSpam(player, this.currentRitual.getErrorForBlockRangeOnFail(player, range, this, offset1, offset2));
            } else {
                ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("ritual.bloodmagic.blockRange.success", new Object[0])});
            }
            return allowed;
        }
        if (player != null) {
            ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("ritual.bloodmagic.blockRange.inactive", new Object[0])});
        }
        return false;
    }

    @Override
    public List<EnumDemonWillType> getActiveWillConfig() {
        return new ArrayList<EnumDemonWillType>(this.currentActiveWillConfig);
    }

    @Override
    public void provideInformationOfWillConfigToPlayer(EntityPlayer player, List<EnumDemonWillType> typeList) {
        if (typeList.size() >= 1) {
            int i;
            Object[] translations = new TextComponentTranslation[typeList.size()];
            String constructedString = "%s";
            for (i = 1; i < typeList.size(); ++i) {
                constructedString = constructedString + ", %s";
            }
            for (i = 0; i < typeList.size(); ++i) {
                translations[i] = new TextComponentTranslation("tooltip.bloodmagic.currentBaseType." + typeList.get((int)i).name.toLowerCase(), new Object[0]);
            }
            ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("ritual.bloodmagic.willConfig.set", new Object[]{new TextComponentTranslation(constructedString, translations)})});
        } else {
            ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("ritual.bloodmagic.willConfig.void", new Object[0])});
        }
    }

    public boolean isPowered() {
        if (this.inverted) {
            return !this.func_145831_w().func_175640_z(this.func_174877_v());
        }
        return this.func_145831_w().func_175640_z(this.func_174877_v());
    }

    public SoulNetwork getCachedNetwork() {
        return this.cachedNetwork;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isRedstoned() {
        return this.redstoned;
    }

    public int getActiveTime() {
        return this.activeTime;
    }

    public Ritual getCurrentRitual() {
        return this.currentRitual;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public List<EnumDemonWillType> getCurrentActiveWillConfig() {
        return this.currentActiveWillConfig;
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }
}

