/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.inversion.InversionPillarHandler;
import WayofTime.bloodmagic.registry.ModBlocks;
import WayofTime.bloodmagic.tile.base.TileTicking;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;

public class TileInversionPillar
extends TileTicking {
    public static double willPerOperation = 0.5;
    public static double inversionPerOperation = 4.0;
    public static double addedInversionPerFailedCheck = 1.0;
    public static double inversionToIncreaseRadius = 100.0;
    public static double inversionToAddPillar = 200.0;
    public static double operationThreshold = 20.0;
    public static double inversionToSpreadWill = 200.0;
    public static double willPushRate = 1.0;
    public static double inversionCostPerWillSpread = 4.0;
    public static double minimumWillForChunkWhenSpreading = 100.0;
    private final IAnimationStateMachine asm;
    private float animationOffsetValue = 0.0f;
    private final TimeValues.VariableValue animationOffset = new TimeValues.VariableValue(0.0f);
    private final TimeValues.VariableValue cycleLength = new TimeValues.VariableValue(4.0f);
    public EnumDemonWillType type;
    public double currentInversion = 0.0;
    public int consecutiveFailedChecks = 0;
    public int consecutiveFailedAirChecks = 0;
    public int currentInfectionRadius = 1;
    public int counter = 0;
    public boolean isRegistered = false;
    public static final double maxWillForChunk = 1000.0;

    public TileInversionPillar() {
        this(EnumDemonWillType.DEFAULT);
    }

    public TileInversionPillar(EnumDemonWillType type) {
        this.type = type;
        this.asm = BloodMagic.proxy.load(new ResourceLocation("bloodmagic".toLowerCase(), "asms/block/inversion_pillar.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"offset", (Object)this.animationOffset, (Object)"cycle_length", (Object)this.cycleLength));
        this.animationOffsetValue = -1.0f;
    }

    @Override
    public void onUpdate() {
        if (this.animationOffsetValue < 0.0f) {
            this.animationOffsetValue = (float)this.func_145831_w().func_82737_E() * this.func_145831_w().field_73012_v.nextFloat();
            this.animationOffset.setValue(this.animationOffsetValue);
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.isRegistered) {
            this.isRegistered = InversionPillarHandler.addPillarToMap(this.func_145831_w(), this.getType(), this.func_174877_v());
        }
        ++this.counter;
        double currentWill = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, this.type);
        if (this.counter % 1 == 0) {
            List<BlockPos> pillarList = this.getNearbyPillarsExcludingThis();
            this.generateWillForNearbyPillars(currentWill, pillarList);
            this.generateInversionForNearbyPillars(currentWill, pillarList);
            int pollute = this.polluteNearbyBlocks(currentWill);
            if (pollute == 1) {
                this.currentInversion += addedInversionPerFailedCheck;
                ++this.consecutiveFailedChecks;
            } else if (pollute == 3) {
                this.currentInversion += addedInversionPerFailedCheck;
                ++this.consecutiveFailedAirChecks;
            } else if (pollute == 0) {
                this.consecutiveFailedChecks = 0;
                this.consecutiveFailedAirChecks = 0;
            }
            if (this.consecutiveFailedAirChecks > 100) {
                this.createObstructionsInAir();
            }
            if (this.currentInversion >= inversionToSpreadWill) {
                this.spreadWillToSurroundingChunks();
            }
            if (this.consecutiveFailedChecks > 5 * this.currentInfectionRadius && this.currentInversion >= inversionToIncreaseRadius) {
                ++this.currentInfectionRadius;
                this.consecutiveFailedChecks = 0;
                this.currentInversion -= inversionToIncreaseRadius;
                System.out.println("Increasing radius!");
            } else if (this.consecutiveFailedAirChecks > 25 * this.currentInfectionRadius) {
                ++this.currentInfectionRadius;
                this.consecutiveFailedChecks = 0;
                this.currentInversion -= inversionToIncreaseRadius;
                System.out.println("Increasing radius due to being in the air!");
            }
            if (this.currentInfectionRadius >= 8 && this.currentInversion >= inversionToAddPillar) {
                List<BlockPos> allConnectedPos = InversionPillarHandler.getAllConnectedPillars(this.func_145831_w(), this.type, this.field_174879_c);
                BlockPos candidatePos = TileInversionPillar.findCandidatePositionForPillar(this.func_145831_w(), this.type, this.field_174879_c, allConnectedPos, 5.0, 10.0);
                if (!candidatePos.equals((Object)BlockPos.field_177992_a)) {
                    this.currentInversion = 0.0;
                    IBlockState pillarState = ModBlocks.INVERSION_PILLAR.func_176203_a(this.type.ordinal());
                    IBlockState bottomState = ModBlocks.INVERSION_PILLAR_END.func_176203_a(this.type.ordinal() * 2);
                    IBlockState topState = ModBlocks.INVERSION_PILLAR_END.func_176203_a(this.type.ordinal() * 2 + 1);
                    this.func_145831_w().func_175656_a(candidatePos, pillarState);
                    this.func_145831_w().func_175656_a(candidatePos.func_177977_b(), bottomState);
                    this.func_145831_w().func_175656_a(candidatePos.func_177984_a(), topState);
                }
            }
        }
    }

    public void createObstructionsInAir() {
        if (this.currentInversion > 1000.0) {
            Vec3d vec = new Vec3d(this.func_145831_w().field_73012_v.nextDouble() * 2.0 - 1.0, this.func_145831_w().field_73012_v.nextDouble() * 2.0 - 1.0, this.func_145831_w().field_73012_v.nextDouble() * 2.0 - 1.0).func_72432_b().func_186678_a((double)(2 * this.currentInfectionRadius));
            BlockPos centralPos = this.field_174879_c.func_177963_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            this.func_145831_w().func_175656_a(centralPos, ModBlocks.DEMON_EXTRAS.func_176203_a(0));
            this.currentInversion -= 1000.0;
        }
    }

    public static BlockPos findCandidatePositionForPillar(World world, EnumDemonWillType type, BlockPos pos, List<BlockPos> posList, double tooCloseDistance, double wantedAverageDistance) {
        int maxIterations = 100;
        int heightCheckRange = 3;
        for (int i = 0; i < maxIterations; ++i) {
            Collections.shuffle(posList);
            BlockPos pillarPos = posList.get(0);
            Vec3d vec = new Vec3d(world.field_73012_v.nextDouble() * 2.0 - 1.0, world.field_73012_v.nextDouble() * 2.0 - 1.0, world.field_73012_v.nextDouble() * 2.0 - 1.0).func_72432_b().func_186678_a(wantedAverageDistance);
            BlockPos centralPos = pillarPos.func_177963_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            BlockPos testPos = null;
            block1: for (int h = 0; h <= heightCheckRange; ++h) {
                for (int sig = -1; sig <= 1; sig += h > 0 ? 2 : 3) {
                    BlockPos candidatePos = centralPos.func_177982_a(0, sig * h, 0);
                    if (!world.func_175623_d(candidatePos) || !world.func_175623_d(candidatePos.func_177984_a()) || !world.func_175623_d(candidatePos.func_177977_b()) || world.func_175623_d(candidatePos.func_177979_c(2))) continue;
                    testPos = candidatePos;
                    break block1;
                }
            }
            if (testPos == null) continue;
            boolean isValid = true;
            for (BlockPos pillarTestPos : posList) {
                if (!(pillarTestPos.func_177951_i(testPos) <= tooCloseDistance * tooCloseDistance)) continue;
                isValid = false;
                break;
            }
            if (!isValid) continue;
            return testPos;
        }
        return BlockPos.field_177992_a;
    }

    public void spreadWillToSurroundingChunks() {
        double currentAmount = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, this.type);
        if (currentAmount <= minimumWillForChunkWhenSpreading) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_176754_o) {
            double drainAmount;
            BlockPos offsetPos = this.field_174879_c.func_177967_a(side, 16);
            double sideAmount = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), offsetPos, this.type);
            if (!(currentAmount > sideAmount) || (drainAmount = Math.min((currentAmount - sideAmount) / 2.0, willPushRate)) < willPushRate / 2.0) continue;
            double drain = WorldDemonWillHandler.drainWill(this.func_145831_w(), this.field_174879_c, this.type, drainAmount, true);
            drain = WorldDemonWillHandler.fillWillToMaximum(this.func_145831_w(), offsetPos, this.type, drain, 1000.0, true);
            this.currentInversion -= drain * inversionCostPerWillSpread;
        }
    }

    public void removePillarFromMap() {
        if (!this.func_145831_w().field_72995_K) {
            InversionPillarHandler.removePillarFromMap(this.func_145831_w(), this.type, this.field_174879_c);
        }
    }

    public List<BlockPos> getNearbyPillarsExcludingThis() {
        return InversionPillarHandler.getNearbyPillars(this.func_145831_w(), this.type, this.field_174879_c);
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        if (!tag.func_74764_b("demonWillType")) {
            this.type = EnumDemonWillType.DEFAULT;
        }
        this.type = EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH));
        this.currentInversion = tag.func_74769_h("currentInversion");
        this.currentInfectionRadius = tag.func_74762_e("currentInfectionRadius");
        this.consecutiveFailedChecks = tag.func_74762_e("consecutiveFailedChecks");
        this.animationOffsetValue = tag.func_74760_g("animationOffset");
        this.animationOffset.setValue(this.animationOffsetValue);
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74778_a("demonWillType", this.type.toString());
        tag.func_74780_a("currentInversion", this.currentInversion);
        tag.func_74768_a("currentInfectionRadius", this.currentInfectionRadius);
        tag.func_74768_a("consecutiveFailedChecks", this.consecutiveFailedChecks);
        tag.func_74776_a("animationOffset", this.animationOffsetValue);
        return tag;
    }

    public void generateWillForNearbyPillars(double currentWillInChunk, List<BlockPos> offsetPositions) {
        double totalGeneratedWill = 0.0;
        double willFactor = currentWillInChunk / 1000.0;
        for (BlockPos offsetPos : offsetPositions) {
            double distanceSquared = offsetPos.func_177951_i((Vec3i)this.field_174879_c);
            totalGeneratedWill += willFactor * 343.0 / (343.0 + Math.pow(distanceSquared, 1.0));
        }
        if (totalGeneratedWill > 0.0) {
            WorldDemonWillHandler.fillWillToMaximum(this.func_145831_w(), this.field_174879_c, this.type, totalGeneratedWill, 1000.0, true);
        }
    }

    public void generateInversionForNearbyPillars(double currentWillInChunk, List<BlockPos> offsetPositions) {
        double willFactor;
        double totalGeneratedInversion = willFactor = currentWillInChunk / 400.0;
        for (BlockPos offsetPos : offsetPositions) {
            double distanceSquared = offsetPos.func_177951_i((Vec3i)this.field_174879_c);
            totalGeneratedInversion += 3125.0 / (3125.0 + Math.pow(distanceSquared, 2.0));
        }
        this.currentInversion = Math.max(0.0, this.currentInversion + totalGeneratedInversion);
    }

    public int polluteNearbyBlocks(double currentWillInChunk) {
        if (currentWillInChunk < operationThreshold || this.currentInversion < inversionPerOperation) {
            return 2;
        }
        for (int i = 0; i < this.currentInfectionRadius; ++i) {
            BlockPos offsetPos;
            int maxInfectionRadius2;
            double zOff;
            double yOff;
            double xOff = (double)(this.func_145831_w().field_73012_v.nextBoolean() ? 1 : -1) * (this.func_145831_w().field_73012_v.nextGaussian() + 1.0) * (double)this.currentInfectionRadius;
            double r2 = xOff * xOff + (yOff = (double)(this.func_145831_w().field_73012_v.nextBoolean() ? 1 : -1) * (this.func_145831_w().field_73012_v.nextGaussian() + 1.0) * (double)this.currentInfectionRadius) * yOff + (zOff = (double)(this.func_145831_w().field_73012_v.nextBoolean() ? 1 : -1) * (this.func_145831_w().field_73012_v.nextGaussian() + 1.0) * (double)this.currentInfectionRadius) * zOff;
            if (r2 > (double)(maxInfectionRadius2 = 9 * this.currentInfectionRadius * this.currentInfectionRadius)) {
                double factor = Math.sqrt((double)maxInfectionRadius2 / r2);
                xOff *= factor;
                yOff *= factor;
                zOff *= factor;
            }
            if ((offsetPos = this.field_174879_c.func_177963_a(xOff + 0.5, yOff + 0.5, zOff + 0.5)).equals((Object)this.field_174879_c)) {
                return 1;
            }
            IBlockState state = this.func_145831_w().func_180495_p(offsetPos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.func_145831_w(), offsetPos)) continue;
            Block block = state.func_177230_c();
            if ((block == Blocks.field_150346_d || block == Blocks.field_150348_b || block == Blocks.field_150349_c) && this.func_145831_w().func_175656_a(offsetPos, ModBlocks.DEMON_EXTRAS.func_176203_a(0))) {
                WorldDemonWillHandler.drainWill(this.func_145831_w(), this.field_174879_c, this.type, willPerOperation, true);
                this.currentInversion -= inversionPerOperation;
                return 0;
            }
            return 1;
        }
        return 3;
    }

    public void handleEvents(float time, Iterable<Event> pastEvents) {
        for (Event event : pastEvents) {
            System.out.println("Event: " + event.event() + " " + event.offset() + " " + this.func_174877_v() + " " + time);
        }
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, side);
    }

    public IAnimationStateMachine getAsm() {
        return this.asm;
    }

    public float getAnimationOffsetValue() {
        return this.animationOffsetValue;
    }

    public TimeValues.VariableValue getAnimationOffset() {
        return this.animationOffset;
    }

    public TimeValues.VariableValue getCycleLength() {
        return this.cycleLength;
    }

    public EnumDemonWillType getType() {
        return this.type;
    }

    public double getCurrentInversion() {
        return this.currentInversion;
    }

    public int getConsecutiveFailedChecks() {
        return this.consecutiveFailedChecks;
    }

    public int getConsecutiveFailedAirChecks() {
        return this.consecutiveFailedAirChecks;
    }

    public int getCurrentInfectionRadius() {
        return this.currentInfectionRadius;
    }

    public int getCounter() {
        return this.counter;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setAnimationOffsetValue(float animationOffsetValue) {
        this.animationOffsetValue = animationOffsetValue;
    }

    public void setType(EnumDemonWillType type) {
        this.type = type;
    }

    public void setCurrentInversion(double currentInversion) {
        this.currentInversion = currentInversion;
    }

    public void setConsecutiveFailedChecks(int consecutiveFailedChecks) {
        this.consecutiveFailedChecks = consecutiveFailedChecks;
    }

    public void setConsecutiveFailedAirChecks(int consecutiveFailedAirChecks) {
        this.consecutiveFailedAirChecks = consecutiveFailedAirChecks;
    }

    public void setCurrentInfectionRadius(int currentInfectionRadius) {
        this.currentInfectionRadius = currentInfectionRadius;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }
}

