/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.structures;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.structures.DungeonRoom;
import WayofTime.bloodmagic.structures.DungeonRoomRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import org.apache.commons.lang3.tuple.Pair;

public class Dungeon {
    public static boolean placeStructureAtPosition(Random rand, WorldServer world, BlockPos pos) {
        long startTime = System.nanoTime();
        HashMap<EnumFacing, List<BlockPos>> availableDoorMap = new HashMap<EnumFacing, List<BlockPos>>();
        ArrayList<AreaDescriptor> descriptorList = new ArrayList<AreaDescriptor>();
        HashMap<BlockPos, Pair> roomMap = new HashMap<BlockPos, Pair>();
        PlacementSettings settings = new PlacementSettings();
        Mirror mir = Mirror.NONE;
        settings.func_186214_a(mir);
        Rotation rot = Rotation.NONE;
        settings.func_186220_a(rot);
        settings.func_186222_a(true);
        settings.func_186218_a(null);
        settings.func_186225_a(null);
        settings.func_186226_b(false);
        DungeonRoom room = Dungeon.getRandomRoom(rand);
        roomMap.put(pos, Pair.of((Object)room, (Object)settings.func_186217_a()));
        descriptorList.addAll(room.getAreaDescriptors(settings, pos));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            List<BlockPos> doorList;
            if (availableDoorMap.containsKey(facing)) {
                doorList = (List<BlockPos>)availableDoorMap.get(facing);
                doorList.addAll(room.getDoorOffsetsForFacing(settings, facing, pos));
                continue;
            }
            doorList = room.getDoorOffsetsForFacing(settings, facing, pos);
            availableDoorMap.put(facing, doorList);
        }
        for (int i = 0; i < 100; ++i) {
            EnumFacing face;
            ArrayList facingList = new ArrayList();
            for (Map.Entry entry : availableDoorMap.entrySet()) {
                if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
                facingList.add(entry.getKey());
            }
            Collections.shuffle(facingList);
            Pair removedDoor1 = null;
            Pair removedDoor2 = null;
            BlockPos roomLocation = null;
            block3: for (EnumFacing doorFacing : facingList) {
                EnumFacing oppositeDoorFacing = doorFacing.func_176734_d();
                List availableDoorList = (List)availableDoorMap.get(doorFacing);
                Collections.shuffle(availableDoorList);
                settings.func_186220_a(Rotation.values()[rand.nextInt(Rotation.values().length)]);
                DungeonRoom testingRoom = Dungeon.getRandomRoom(rand);
                List<BlockPos> otherDoorList = testingRoom.getDoorOffsetsForFacing(settings, oppositeDoorFacing, BlockPos.field_177992_a);
                if (otherDoorList == null || otherDoorList.isEmpty()) continue;
                Collections.shuffle(otherDoorList);
                BlockPos testDoor = otherDoorList.get(0);
                Iterator iterator = availableDoorList.iterator();
                if (!iterator.hasNext()) continue;
                BlockPos availableDoor = (BlockPos)iterator.next();
                roomLocation = availableDoor.func_177973_b((Vec3i)testDoor).func_177971_a(doorFacing.func_176730_m());
                List<AreaDescriptor> descriptors = testingRoom.getAreaDescriptors(settings, roomLocation);
                for (AreaDescriptor testDesc : descriptors) {
                    for (AreaDescriptor currentDesc : descriptorList) {
                        if (!testDesc.intersects(currentDesc)) continue;
                        continue block3;
                    }
                }
                roomMap.put(roomLocation, Pair.of((Object)testingRoom, (Object)settings.func_186217_a()));
                descriptorList.addAll(descriptors);
                removedDoor1 = Pair.of((Object)doorFacing, (Object)availableDoor);
                removedDoor2 = Pair.of((Object)oppositeDoorFacing, (Object)testDoor.func_177971_a((Vec3i)roomLocation));
                room = testingRoom;
                break;
            }
            if (removedDoor1 != null) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    List<BlockPos> doorList;
                    if (availableDoorMap.containsKey(facing)) {
                        doorList = (List<BlockPos>)availableDoorMap.get(facing);
                        doorList.addAll(room.getDoorOffsetsForFacing(settings, facing, roomLocation));
                        continue;
                    }
                    doorList = room.getDoorOffsetsForFacing(settings, facing, roomLocation);
                    availableDoorMap.put(facing, doorList);
                }
                face = (EnumFacing)removedDoor1.getKey();
                if (availableDoorMap.containsKey(face)) {
                    ((List)availableDoorMap.get(face)).remove(removedDoor1.getRight());
                }
            }
            if (removedDoor2 == null || !availableDoorMap.containsKey(face = (EnumFacing)removedDoor2.getKey())) continue;
            ((List)availableDoorMap.get(face)).remove(removedDoor2.getRight());
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        System.out.println("Duration: " + duration + "(ns), " + duration / 1000000L + "(ms)");
        for (Map.Entry entry : roomMap.entrySet()) {
            BlockPos placementPos = (BlockPos)entry.getKey();
            DungeonRoom placedRoom = (DungeonRoom)((Pair)entry.getValue()).getKey();
            PlacementSettings placementSettings = (PlacementSettings)((Pair)entry.getValue()).getValue();
            placedRoom.placeStructureAtPosition(rand, placementSettings, world, placementPos);
        }
        return false;
    }

    public static DungeonRoom getRandomRoom(Random rand) {
        return DungeonRoomRegistry.getRandomDungeonRoom(rand);
    }
}

