/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.tile.TileAltar;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RitualWellOfSuffering
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    public static final String DAMAGE_RANGE = "damage";
    public static final int SACRIFICE_AMOUNT = 25;
    public BlockPos altarOffsetPos = new BlockPos(0, 0, 0);

    public RitualWellOfSuffering() {
        super("ritualWellOfSuffering", 0, 40000, "ritual.bloodmagic.wellOfSufferingRitual");
        this.addBlockRange(ALTAR_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(DAMAGE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
        this.setMaximumVolumeAndDistanceOfRange(DAMAGE_RANGE, 0, 15, 15);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        BlockPos altarPos = pos.func_177971_a((Vec3i)this.altarOffsetPos);
        TileEntity tile = world.func_175625_s(altarPos);
        AreaDescriptor altarRange = this.getBlockRange(ALTAR_RANGE);
        if (!altarRange.isWithinArea(this.altarOffsetPos) || !(tile instanceof TileAltar)) {
            for (BlockPos newPos : altarRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!(nextTile instanceof TileAltar)) continue;
                tile = nextTile;
                this.altarOffsetPos = newPos.func_177973_b((Vec3i)pos);
                altarRange.resetCache();
                break;
            }
        }
        if (tile instanceof TileAltar) {
            TileAltar tileAltar = (TileAltar)tile;
            AreaDescriptor damageRange = this.getBlockRange(DAMAGE_RANGE);
            AxisAlignedBB range = damageRange.getAABB(pos);
            List entities = world.func_72872_a(EntityLivingBase.class, range);
            for (EntityLivingBase entity : entities) {
                if (ConfigHandler.wellOfSufferingBlacklist.contains(entity.getClass().getSimpleName())) continue;
                String simpleClassName = entity.getClass().getSimpleName();
                if (BloodMagicAPI.getEntitySacrificeValues().containsKey(simpleClassName) && BloodMagicAPI.getEntitySacrificeValues().get(simpleClassName) <= 0 || !entity.func_70089_S() || entity instanceof EntityPlayer || !entity.func_70097_a(DamageSource.field_76380_i, 1.0f)) continue;
                String entityName = entity.getClass().getSimpleName();
                int lifeEssenceRatio = 25;
                if (ConfigHandler.entitySacrificeValues.containsKey(entityName)) {
                    lifeEssenceRatio = ConfigHandler.entitySacrificeValues.get(entityName);
                }
                if (BloodMagicAPI.getEntitySacrificeValues().containsKey(entityName)) {
                    lifeEssenceRatio = BloodMagicAPI.getEntitySacrificeValues().get(entityName);
                }
                if (entity.func_70631_g_()) {
                    lifeEssenceRatio = (int)((float)lifeEssenceRatio * 0.5f);
                }
                tileAltar.sacrificialDaggerCall(lifeEssenceRatio, true);
                if (++totalEffects < maxEffects) continue;
                break;
            }
        }
        masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost() * totalEffects);
    }

    @Override
    public int getRefreshTime() {
        return 25;
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 1, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, -1, EnumRuneType.EARTH);
        this.addCornerRunes(components, -3, -1, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 2, 4, -1, EnumRuneType.WATER);
        this.addOffsetRunes(components, 1, 4, 0, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 1, EnumRuneType.AIR);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualWellOfSuffering();
    }
}

