/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.util.helper.ItemHelper;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.registry.ModItems;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualUpgradeRemove
extends Ritual {
    public static final String CHECK_RANGE = "fillRange";

    public RitualUpgradeRemove() {
        super("ritualUpgradeRemove", 0, 25000, "ritual.bloodmagic.upgradeRemoveRitual");
        this.addBlockRange(CHECK_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1, 2, 1));
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        AreaDescriptor checkRange = this.getBlockRange(CHECK_RANGE);
        List playerList = world.func_72872_a(EntityPlayer.class, checkRange.getAABB(pos));
        for (EntityPlayer player : playerList) {
            if (!LivingArmour.hasFullSet(player)) continue;
            boolean removedUpgrade = false;
            ItemStack chestStack = ((ItemStack[])Iterables.toArray((Iterable)player.func_184193_aE(), ItemStack.class))[2];
            LivingArmour armour = ItemLivingArmour.getLivingArmour(chestStack);
            if (armour == null) continue;
            HashMap upgradeMap = (HashMap)armour.upgradeMap.clone();
            for (Map.Entry entry : upgradeMap.entrySet()) {
                LivingArmourUpgrade upgrade = (LivingArmourUpgrade)entry.getValue();
                String upgradeKey = (String)entry.getKey();
                ItemStack upgradeStack = new ItemStack(ModItems.UPGRADE_TOME);
                ItemHelper.LivingUpgrades.setKey(upgradeStack, upgradeKey);
                ItemHelper.LivingUpgrades.setLevel(upgradeStack, upgrade.getUpgradeLevel());
                boolean successful = armour.removeUpgrade(player, upgrade);
                if (!successful) continue;
                removedUpgrade = true;
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, upgradeStack));
                for (Map.Entry<String, StatTracker> trackerEntry : armour.trackerMap.entrySet()) {
                    StatTracker tracker = trackerEntry.getValue();
                    if (tracker == null || !tracker.providesUpgrade(upgradeKey)) continue;
                    tracker.resetTracker();
                }
            }
            if (!removedUpgrade) continue;
            ((ItemLivingArmour)chestStack.func_77973_b()).setLivingArmour(chestStack, armour, true);
            ItemLivingArmour.setLivingArmour(chestStack, armour);
            armour.recalculateUpgradePoints();
            masterRitualStone.setActive(false);
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p(), true));
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 1, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 3, EnumRuneType.WATER);
        this.addParallelRunes(components, 1, 4, EnumRuneType.AIR);
        for (int i = 0; i < 4; ++i) {
            this.addCornerRunes(components, 3, i, EnumRuneType.EARTH);
        }
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualUpgradeRemove();
    }
}

