/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class RitualFelling
extends Ritual {
    public static final String FELLING_RANGE = "fellingRange";
    public static final String CHEST_RANGE = "chest";
    private ArrayList<BlockPos> treePartsCache;
    private Iterator<BlockPos> blockPosIterator;
    private boolean cached = false;
    private BlockPos currentPos;

    public RitualFelling() {
        super("ritualFelling", 0, 20000, "ritual.bloodmagic.fellingRitual");
        this.addBlockRange(FELLING_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, -3, -10), new BlockPos(11, 27, 11)));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(FELLING_RANGE, 14000, 15, 30);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
        this.treePartsCache = new ArrayList();
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getBlockPos();
        AreaDescriptor chestRange = this.getBlockRange(CHEST_RANGE);
        TileEntity tileInventory = world.func_175625_s(chestRange.getContainedPositions(masterPos).get(0));
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        if (!this.cached || this.treePartsCache.isEmpty()) {
            for (BlockPos blockPos : this.getBlockRange(FELLING_RANGE).getContainedPositions(masterRitualStone.getBlockPos())) {
                if (this.treePartsCache.contains(blockPos) || world.func_175623_d(blockPos) || !world.func_180495_p(blockPos).func_177230_c().isWood((IBlockAccess)world, blockPos) && !world.func_180495_p(blockPos).func_177230_c().isLeaves(world.func_180495_p(blockPos), (IBlockAccess)world, blockPos)) continue;
                this.treePartsCache.add(blockPos);
            }
            this.cached = true;
            this.blockPosIterator = this.treePartsCache.iterator();
        }
        if (this.blockPosIterator.hasNext() && tileInventory != null) {
            masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost());
            this.currentPos = this.blockPosIterator.next();
            IItemHandler inventory = Utils.getInventory(tileInventory, EnumFacing.DOWN);
            this.placeInInventory(world.func_180495_p(this.currentPos), world, this.currentPos, inventory);
            world.func_175698_g(this.currentPos);
            this.blockPosIterator.remove();
        }
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 1, EnumRuneType.EARTH);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFelling();
    }

    private void placeInInventory(IBlockState choppedState, World world, BlockPos choppedPos, @Nullable IItemHandler inventory) {
        if (inventory == null) {
            return;
        }
        for (ItemStack stack : choppedState.func_177230_c().getDrops((IBlockAccess)world, choppedPos, world.func_180495_p(choppedPos), 0)) {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
            if (remainder.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)choppedPos.func_177958_n() + 0.4, (double)(choppedPos.func_177956_o() + 2), (double)choppedPos.func_177952_p() + 0.4, remainder));
        }
    }
}

