/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualContainment
extends Ritual {
    public static final String CONTAINMENT_RANGE = "containmentRange";

    public RitualContainment() {
        super("ritualContainment", 0, 2000, "ritual.bloodmagic.containmentRitual");
        this.addBlockRange(CONTAINMENT_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-3, 0, -3), 7));
        this.setMaximumVolumeAndDistanceOfRange(CONTAINMENT_RANGE, 0, 10, 10);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        AreaDescriptor containmentRange = this.getBlockRange(CONTAINMENT_RANGE);
        for (EntityLivingBase entity : world.func_72872_a(EntityLivingBase.class, containmentRange.getAABB(masterRitualStone.getBlockPos()))) {
            if (entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || PlayerHelper.getUUIDFromPlayer((EntityPlayer)entity).toString().equals(masterRitualStone.getOwner()))) continue;
            double xDif = entity.field_70165_t - ((double)masterRitualStone.getBlockPos().func_177958_n() + 0.5);
            double yDif = entity.field_70163_u - ((double)masterRitualStone.getBlockPos().func_177956_o() + 2.5);
            double zDif = entity.field_70161_v - ((double)masterRitualStone.getBlockPos().func_177952_p() + 0.5);
            entity.field_70159_w = -0.05 * xDif;
            entity.field_70181_x = -0.05 * yDif;
            entity.field_70179_y = -0.05 * zDif;
            entity.field_70143_R = 0.0f;
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 1;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addParallelRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 1, 5, EnumRuneType.EARTH);
        this.addCornerRunes(components, 2, 5, EnumRuneType.EARTH);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualContainment();
    }
}

