/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.recipe.alchemyTable;

import WayofTime.bloodmagic.api.recipe.AlchemyTableRecipe;
import WayofTime.bloodmagic.registry.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class AlchemyTablePotionRecipe
extends AlchemyTableRecipe {
    public static final ItemStack basePotionFlaskStack = new ItemStack(ModItems.POTION_FLASK, 1, Short.MAX_VALUE);
    protected PotionEffect baseEffect;
    public static final int temporaryMaximumEffectsOnThePotionFlaskYesThisIsALongFieldItIsJustSoIRemember = 3;
    protected double baseAddedImpurity = 5.0;

    public AlchemyTablePotionRecipe(int lpDrained, int ticksRequired, int tierRequired, List<ItemStack> inputItems, PotionEffect baseEffect) {
        super(basePotionFlaskStack, lpDrained, ticksRequired, tierRequired, new Object[0]);
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        for (ItemStack stack : inputItems) {
            recipe.add(stack);
        }
        recipe.add(basePotionFlaskStack);
        this.input = recipe;
        this.baseEffect = baseEffect;
    }

    public AlchemyTablePotionRecipe(int lpDrained, int ticksRequired, int tierRequired, ItemStack inputItem, PotionEffect baseEffect) {
        this(lpDrained, ticksRequired, tierRequired, Collections.singletonList(inputItem), baseEffect);
    }

    @Override
    public ItemStack getRecipeOutput(List<ItemStack> inputList) {
        int flaskLocation = -1;
        for (int x = 0; x < inputList.size(); ++x) {
            boolean match;
            ItemStack slot = inputList.get(x);
            if (slot == null) continue;
            boolean bl = match = slot.func_77973_b() == ModItems.POTION_FLASK;
            if (!match) continue;
            flaskLocation = x;
        }
        if (flaskLocation != -1) {
            return this.getModifiedFlaskForInput(inputList.get(flaskLocation));
        }
        return this.getModifiedFlaskForInput(ItemStack.field_190927_a);
    }

    @Override
    public boolean matches(List<ItemStack> checkedList, World world, BlockPos pos) {
        ArrayList required = new ArrayList(this.input);
        for (ItemStack slot : checkedList) {
            if (slot == null) continue;
            boolean inRecipe = false;
            for (Object aRequired : required) {
                boolean match = false;
                Object next = aRequired;
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                if (next instanceof ItemStack && ((ItemStack)next).func_77973_b() == ModItems.POTION_FLASK && !this.isPotionFlaskValidInput(slot)) break;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public boolean isPotionFlaskValidInput(ItemStack stack) {
        List effectList = PotionUtils.func_185189_a((ItemStack)stack);
        if (effectList.size() >= 3) {
            return false;
        }
        for (PotionEffect eff : effectList) {
            if (eff.func_188419_a() != this.baseEffect.func_188419_a()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getModifiedFlaskForInput(ItemStack inputStack) {
        if (inputStack.func_190926_b()) {
            ItemStack outputStack = new ItemStack(ModItems.POTION_FLASK);
            ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>();
            effectList.add(this.baseEffect);
            PotionUtils.func_185184_a((ItemStack)outputStack, effectList);
            return outputStack;
        }
        ItemStack outputStack = inputStack.func_77946_l();
        List effectList = PotionUtils.func_185189_a((ItemStack)outputStack);
        effectList.add(this.baseEffect);
        PotionUtils.func_185184_a((ItemStack)outputStack, (Collection)effectList);
        return outputStack;
    }
}

