/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.recipe.alchemyTable;

import WayofTime.bloodmagic.potion.BMPotionUtils;
import WayofTime.bloodmagic.recipe.alchemyTable.AlchemyTablePotionRecipe;
import WayofTime.bloodmagic.registry.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;

public class AlchemyTablePotionAugmentRecipe
extends AlchemyTablePotionRecipe {
    protected double lengthAugment = 0.0;
    protected int powerAugment = 0;
    protected Potion wantedPotion;

    public AlchemyTablePotionAugmentRecipe(int lpDrained, int ticksRequired, int tierRequired, List<ItemStack> inputItems, PotionEffect baseEffect, double lengthAugment, int powerAugment) {
        super(lpDrained, ticksRequired, tierRequired, inputItems, baseEffect);
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        for (ItemStack stack : inputItems) {
            recipe.add(stack);
        }
        recipe.add(AlchemyTablePotionAugmentRecipe.getAugmentedPotionFlask(baseEffect));
        this.input = recipe;
        this.wantedPotion = baseEffect.func_188419_a();
        this.lengthAugment = lengthAugment;
        this.powerAugment = powerAugment;
    }

    public AlchemyTablePotionAugmentRecipe(int lpDrained, int ticksRequired, int tierRequired, ItemStack inputItem, PotionEffect baseEffect, double lengthAugment, int powerAugment) {
        this(lpDrained, ticksRequired, tierRequired, Collections.singletonList(inputItem), baseEffect, lengthAugment, powerAugment);
    }

    @Override
    public boolean isPotionFlaskValidInput(ItemStack stack) {
        List effectList = PotionUtils.func_185189_a((ItemStack)stack);
        for (PotionEffect eff : effectList) {
            if (eff.func_188419_a() != this.wantedPotion) continue;
            double currentAugment = BMPotionUtils.getLengthAugment(stack, this.wantedPotion);
            return currentAugment < this.lengthAugment || eff.func_76458_c() < this.powerAugment;
        }
        return false;
    }

    @Override
    public ItemStack getModifiedFlaskForInput(ItemStack inputStack) {
        if (inputStack == null) {
            ItemStack outputStack = new ItemStack(ModItems.POTION_FLASK);
            ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>();
            int potionLength = this.wantedPotion.func_76403_b() ? 1 : BMPotionUtils.getAugmentedLength(this.baseEffect.func_76459_b(), this.lengthAugment, this.powerAugment - this.baseEffect.func_76458_c());
            effectList.add(new PotionEffect(this.wantedPotion, potionLength, this.powerAugment - this.baseEffect.func_76458_c()));
            BMPotionUtils.setEffects(outputStack, effectList);
            return outputStack;
        }
        ItemStack outputStack = inputStack.func_77946_l();
        List effectList = PotionUtils.func_185189_a((ItemStack)outputStack);
        ArrayList<PotionEffect> newEffectList = new ArrayList<PotionEffect>();
        for (PotionEffect effect : effectList) {
            if (effect.func_188419_a() == this.wantedPotion) {
                double currentLengthAugment = Math.max(this.lengthAugment, BMPotionUtils.getLengthAugment(outputStack, this.wantedPotion));
                int currentPowerAugment = Math.max(this.powerAugment, effect.func_76458_c());
                int potionLength = this.wantedPotion.func_76403_b() ? 1 : BMPotionUtils.getAugmentedLength(this.baseEffect.func_76459_b(), currentLengthAugment, currentPowerAugment);
                newEffectList.add(new PotionEffect(this.wantedPotion, potionLength, currentPowerAugment));
                BMPotionUtils.setLengthAugment(outputStack, this.wantedPotion, currentLengthAugment);
                continue;
            }
            newEffectList.add(effect);
        }
        BMPotionUtils.setEffects(outputStack, newEffectList);
        return outputStack;
    }

    public static ItemStack getAugmentedPotionFlask(PotionEffect baseEffect) {
        ItemStack outputStack = new ItemStack(ModItems.POTION_FLASK);
        ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>();
        effectList.add(baseEffect);
        BMPotionUtils.setEffects(outputStack, effectList);
        return outputStack;
    }
}

