/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.meteor;

import WayofTime.bloodmagic.meteor.MeteorComponent;
import WayofTime.bloodmagic.util.Utils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Meteor {
    private static final Random RAND = new Random();
    private final ItemStack catalystStack;
    private final List<MeteorComponent> components;
    private final float explosionStrength;
    private final int radius;
    private final int maxWeight;
    public int version;

    public Meteor(ItemStack catalystStack, List<MeteorComponent> components, float explosionStrength, int radius) {
        this.catalystStack = catalystStack;
        this.components = components;
        this.explosionStrength = explosionStrength;
        this.radius = radius;
        int weight = 0;
        for (MeteorComponent component : components) {
            weight += component.getWeight();
        }
        this.maxWeight = weight;
    }

    public void generateMeteor(World world, BlockPos pos, IBlockState fillerBlock, double radiusModifier, double explosionModifier, double fillerChance) {
        world.func_72885_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)((double)this.explosionStrength * explosionModifier), true, true);
        int radius = (int)Math.ceil((double)this.getRadius() * radiusModifier);
        double floatingRadius = (double)this.getRadius() * radiusModifier;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    IBlockState placedState;
                    if ((double)(i * i + j * j + k * k) > (floatingRadius + 0.5) * (floatingRadius + 0.5)) continue;
                    BlockPos newPos = pos.func_177982_a(i, j, k);
                    IBlockState state = world.func_180495_p(newPos);
                    if (!world.func_175623_d(newPos) && !Utils.isBlockLiquid(state) || (placedState = this.getRandomOreFromComponents(fillerBlock, fillerChance)) == null) continue;
                    world.func_175656_a(newPos, placedState);
                }
            }
        }
    }

    public IBlockState getRandomOreFromComponents(IBlockState fillerBlock, double fillerChance) {
        int goal = RAND.nextInt(this.getMaxWeight());
        for (MeteorComponent component : this.getComponents()) {
            if ((goal -= component.getWeight()) >= 0) continue;
            IBlockState state = component.getStateFromOre();
            if (state != null) {
                return state;
            }
            return RAND.nextDouble() > fillerChance ? fillerBlock : null;
        }
        return RAND.nextDouble() > fillerChance ? fillerBlock : null;
    }

    public ItemStack getCatalystStack() {
        return this.catalystStack;
    }

    public List<MeteorComponent> getComponents() {
        return this.components;
    }

    public float getExplosionStrength() {
        return this.explosionStrength;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getMaxWeight() {
        return this.maxWeight;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

