/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeSelfSacrifice;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerSelfSacrifice
extends StatTracker {
    public static HashMap<LivingArmour, Integer> changeMap = new HashMap();
    public static int[] sacrificesRequired = new int[]{30, 200, 400, 700, 1100, 1500, 2000, 2800, 3600, 5000};
    public int totalSacrifices = 0;

    public static void incrementCounter(LivingArmour armour, int hearts) {
        changeMap.put(armour, changeMap.containsKey(armour) ? changeMap.get(armour) + hearts : hearts);
    }

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.tracker.selfSacrifice";
    }

    @Override
    public void resetTracker() {
        this.totalSacrifices = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalSacrifices = tag.func_74762_e("bloodmagic.tracker.selfSacrifice");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("bloodmagic.tracker.selfSacrifice", this.totalSacrifices);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        int change;
        if (changeMap.containsKey(livingArmour) && (change = Math.abs(changeMap.get(livingArmour))) > 0) {
            this.totalSacrifices += Math.abs(changeMap.get(livingArmour));
            changeMap.put(livingArmour, 0);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (changeMap.containsKey(livingArmour)) {
            changeMap.remove(livingArmour);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 10; ++i) {
            if (this.totalSacrifices < sacrificesRequired[i]) continue;
            upgradeList.add(new LivingArmourUpgradeSelfSacrifice(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalSacrifices, sacrificesRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("bloodmagic.upgrade.selfSacrifice");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeSelfSacrifice && (level = upgrade.getUpgradeLevel()) < sacrificesRequired.length) {
            this.totalSacrifices = Math.max(this.totalSacrifices, sacrificesRequired[level]);
            this.markDirty();
        }
    }
}

