/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradePoisonResist;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerPoison
extends StatTracker {
    public int totalPoisonTicks = 0;
    public static int[] poisonTicksRequired = new int[]{1200, 3600, 12000, 24000, 30000};

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.tracker.poison";
    }

    @Override
    public void resetTracker() {
        this.totalPoisonTicks = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalPoisonTicks = tag.func_74762_e("bloodmagic.tracker.poison");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("bloodmagic.tracker.poison", this.totalPoisonTicks);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            ++this.totalPoisonTicks;
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 5; ++i) {
            if (this.totalPoisonTicks < poisonTicksRequired[i]) continue;
            upgradeList.add(new LivingArmourUpgradePoisonResist(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalPoisonTicks, poisonTicksRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("bloodmagic.upgrade.poisonResist");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradePoisonResist && (level = upgrade.getUpgradeLevel()) < poisonTicksRequired.length) {
            this.totalPoisonTicks = Math.max(this.totalPoisonTicks, poisonTicksRequired[level]);
            this.markDirty();
        }
    }
}

