/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeSpeed;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerMovement
extends StatTracker {
    public static Map<EntityPlayer, Double> lastPosX = new HashMap<EntityPlayer, Double>();
    public static Map<EntityPlayer, Double> lastPosZ = new HashMap<EntityPlayer, Double>();
    public static int[] blocksRequired = new int[]{200, 1000, 2000, 4000, 7000, 15000, 25000, 35000, 50000, 70000};
    public double totalMovement = 0.0;

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.tracker.movement";
    }

    @Override
    public void resetTracker() {
        this.totalMovement = 0.0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalMovement = tag.func_74769_h("bloodmagic.tracker.movement");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("bloodmagic.tracker.movement", this.totalMovement);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (!lastPosX.containsKey(player)) {
            lastPosX.put(player, player.field_70165_t);
            lastPosZ.put(player, player.field_70161_v);
            return false;
        }
        if (!player.field_70122_E) {
            return false;
        }
        double distanceTravelled = Math.sqrt(Math.pow(lastPosX.get(player) - player.field_70165_t, 2.0) + Math.pow(lastPosZ.get(player) - player.field_70161_v, 2.0));
        if (distanceTravelled > 1.0E-4 && distanceTravelled < 2.0) {
            this.totalMovement += distanceTravelled;
            lastPosX.put(player, player.field_70165_t);
            lastPosZ.put(player, player.field_70161_v);
            this.markDirty();
            return true;
        }
        lastPosX.put(player, player.field_70165_t);
        lastPosZ.put(player, player.field_70161_v);
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 10; ++i) {
            if (!(this.totalMovement >= (double)blocksRequired[i])) continue;
            upgradeList.add(new LivingArmourUpgradeSpeed(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalMovement, blocksRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("bloodmagic.upgrade.movement");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeSpeed && (level = upgrade.getUpgradeLevel()) < blocksRequired.length) {
            this.totalMovement = Math.max(this.totalMovement, (double)blocksRequired[level]);
            this.markDirty();
        }
    }
}

