/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeGrimReaperSprint;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerGrimReaperSprint
extends StatTracker {
    public int totalDeaths = 0;
    public static HashMap<LivingArmour, Integer> changeMap = new HashMap();
    public static int[] deathsRequired = new int[]{6, 10, 15, 25, 50, 70, 90, 120, 150, 200};

    public static void incrementCounter(LivingArmour armour) {
        StatTracker tracker = armour.getTracker("bloodmagic.tracker.grimReaper");
        if (tracker instanceof StatTrackerGrimReaperSprint) {
            ++((StatTrackerGrimReaperSprint)tracker).totalDeaths;
            System.out.println(((StatTrackerGrimReaperSprint)tracker).totalDeaths);
            tracker.markDirty();
        }
    }

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.tracker.grimReaper";
    }

    @Override
    public void resetTracker() {
        this.totalDeaths = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalDeaths = tag.func_74762_e("bloodmagic.tracker.grimReaper");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("bloodmagic.tracker.grimReaper", this.totalDeaths);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        double change;
        if (changeMap.containsKey(livingArmour) && (change = (double)Math.abs(changeMap.get(livingArmour))) > 0.0) {
            this.totalDeaths += Math.abs(changeMap.get(livingArmour));
            changeMap.put(livingArmour, 0);
            this.markDirty();
            return true;
        }
        return true;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (changeMap.containsKey(livingArmour)) {
            changeMap.remove(livingArmour);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 10; ++i) {
            if (this.totalDeaths < deathsRequired[i]) continue;
            upgradeList.add(new LivingArmourUpgradeGrimReaperSprint(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalDeaths, deathsRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("bloodmagic.upgrade.grimReaper");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeGrimReaperSprint && (level = upgrade.getUpgradeLevel()) < deathsRequired.length) {
            this.totalDeaths = Math.max(this.totalDeaths, deathsRequired[level]);
            this.markDirty();
        }
    }
}

