/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeFireResist;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerFireResist
extends StatTracker {
    public int totalFireTicks = 0;
    public static int[] fireTicksRequired = new int[]{1200, 3600, 12000, 24000, 30000};

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.tracker.fire";
    }

    @Override
    public void resetTracker() {
        this.totalFireTicks = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalFireTicks = tag.func_74762_e("bloodmagic.tracker.fire");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("bloodmagic.tracker.fire", this.totalFireTicks);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (player.func_70027_ad()) {
            ++this.totalFireTicks;
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 5; ++i) {
            if (this.totalFireTicks < fireTicksRequired[i]) continue;
            upgradeList.add(new LivingArmourUpgradeFireResist(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalFireTicks, fireTicksRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("bloodmagic.upgrade.fireResist");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeFireResist && (level = upgrade.getUpgradeLevel()) < fireTicksRequired.length) {
            this.totalFireTicks = Math.max(this.totalFireTicks, fireTicksRequired[level]);
            this.markDirty();
        }
    }
}

