/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.soul;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.iface.IMultiWillTool;
import WayofTime.bloodmagic.api.iface.ISentientSwordEffectProvider;
import WayofTime.bloodmagic.api.iface.ISentientTool;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDemonWill;
import WayofTime.bloodmagic.api.soul.IDemonWillWeapon;
import WayofTime.bloodmagic.api.soul.PlayerDemonWillHandler;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.client.mesh.CustomMeshDefinitionMultiWill;
import WayofTime.bloodmagic.entity.mob.EntitySentientSpecter;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSentientSword
extends ItemSword
implements IDemonWillWeapon,
IMeshProvider,
IMultiWillTool,
ISentientTool {
    public static int[] soulBracket = new int[]{16, 60, 200, 400, 1000, 2000, 4000};
    public static double[] defaultDamageAdded = new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0};
    public static double[] destructiveDamageAdded = new double[]{1.5, 2.25, 3.0, 3.75, 4.5, 5.25, 6.0};
    public static double[] vengefulDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.25, 2.5};
    public static double[] steadfastDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.25, 2.5};
    public static double[] soulDrainPerSwing = new double[]{0.05, 0.1, 0.2, 0.4, 0.75, 1.0, 1.25};
    public static double[] soulDrop = new double[]{2.0, 4.0, 7.0, 10.0, 13.0, 15.0, 18.0};
    public static double[] staticDrop = new double[]{1.0, 1.0, 2.0, 3.0, 3.0, 4.0, 4.0};
    public static double[] healthBonus = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public static double[] vengefulAttackSpeed = new double[]{-2.1, -2.0, -1.8, -1.7, -1.6, -1.6, -1.5};
    public static double[] destructiveAttackSpeed = new double[]{-2.6, -2.7, -2.8, -2.9, -3.0, -3.0, -3.0};
    public static int[] absorptionTime = new int[]{200, 300, 400, 500, 600, 700, 800};
    public static double maxAbsorptionHearts = 10.0;
    public static int[] poisonTime = new int[]{25, 50, 60, 80, 100, 120, 150};
    public static int[] poisonLevel = new int[]{0, 0, 0, 1, 1, 1, 1};
    public static double[] movementSpeed = new double[]{0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4};

    public ItemSentientSword() {
        super(ModItems.SOUL_TOOL_MATERIAL);
        this.func_77655_b("bloodmagic.sentientSword");
        this.func_77637_a(BloodMagic.tabBloodMagic);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ModItems.ITEM_DEMON_CRYSTAL == repair.func_77973_b() || super.func_82789_a(toRepair, repair);
    }

    public void recalculatePowers(ItemStack stack, World world, EntityPlayer player) {
        EnumDemonWillType type = PlayerDemonWillHandler.getLargestWillType(player);
        double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
        this.recalculatePowers(stack, type, soulsRemaining);
    }

    public void recalculatePowers(ItemStack stack, EnumDemonWillType type, double will) {
        this.setCurrentType(stack, will > 0.0 ? type : EnumDemonWillType.DEFAULT);
        int level = this.getLevel(stack, will);
        double drain = level >= 0 ? soulDrainPerSwing[level] : 0.0;
        double extraDamage = this.getExtraDamage(type, level);
        this.setDrainOfActivatedSword(stack, drain);
        this.setDamageOfActivatedSword(stack, 5.0 + extraDamage);
        this.setStaticDropOfActivatedSword(stack, level >= 0 ? staticDrop[level] : 1.0);
        this.setDropOfActivatedSword(stack, level >= 0 ? soulDrop[level] : 0.0);
        this.setAttackSpeedOfSword(stack, level >= 0 ? this.getAttackSpeed(type, level) : -2.4);
        this.setHealthBonusOfSword(stack, level >= 0 ? this.getHealthBonus(type, level) : 0.0);
        this.setSpeedOfSword(stack, level >= 0 ? this.getMovementSpeed(type, level) : 0.0);
    }

    public double getExtraDamage(EnumDemonWillType type, int willBracket) {
        if (willBracket < 0) {
            return 0.0;
        }
        switch (type) {
            case CORROSIVE: 
            case DEFAULT: {
                return defaultDamageAdded[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveDamageAdded[willBracket];
            }
            case VENGEFUL: {
                return vengefulDamageAdded[willBracket];
            }
            case STEADFAST: {
                return steadfastDamageAdded[willBracket];
            }
        }
        return 0.0;
    }

    public double getAttackSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return vengefulAttackSpeed[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveAttackSpeed[willBracket];
            }
        }
        return -2.4;
    }

    public double getHealthBonus(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case STEADFAST: {
                return healthBonus[willBracket];
            }
        }
        return 0.0;
    }

    public double getMovementSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return movementSpeed[willBracket];
            }
        }
        return 0.0;
    }

    public void applyEffectToEntity(EnumDemonWillType type, int willBracket, EntityLivingBase target, EntityLivingBase attacker) {
        switch (type) {
            case CORROSIVE: {
                target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, poisonTime[willBracket], poisonLevel[willBracket]));
                break;
            }
            case DEFAULT: {
                break;
            }
            case DESTRUCTIVE: {
                break;
            }
            case STEADFAST: {
                if (target.func_70089_S()) break;
                float absorption = attacker.func_110139_bj();
                attacker.func_70690_d(new PotionEffect(MobEffects.field_76444_x, absorptionTime[willBracket], 127));
                attacker.func_110149_m((float)Math.min((double)(absorption + target.func_110138_aP() * 0.05f), maxAbsorptionHearts));
                break;
            }
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (super.func_77644_a(stack, target, attacker)) {
            if (attacker instanceof EntityPlayer) {
                ISentientSwordEffectProvider provider;
                EntityPlayer attackerPlayer = (EntityPlayer)attacker;
                this.recalculatePowers(stack, attackerPlayer.func_130014_f_(), attackerPlayer);
                EnumDemonWillType type = this.getCurrentType(stack);
                double will = PlayerDemonWillHandler.getTotalDemonWill(type, attackerPlayer);
                int willBracket = this.getLevel(stack, will);
                this.applyEffectToEntity(type, willBracket, target, (EntityLivingBase)attackerPlayer);
                ItemStack offStack = attackerPlayer.func_184582_a(EntityEquipmentSlot.OFFHAND);
                if (offStack.func_77973_b() instanceof ISentientSwordEffectProvider && (provider = (ISentientSwordEffectProvider)offStack.func_77973_b()).providesEffectForWill(type)) {
                    provider.applyOnHitEffect(type, stack, offStack, attacker, target);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumDemonWillType getCurrentType(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH));
    }

    public void setCurrentType(ItemStack stack, EnumDemonWillType type) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("demonWillType", type.toString());
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        this.recalculatePowers(player.func_184586_b(hand), world, player);
        return super.func_77659_a(world, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    private int getLevel(ItemStack stack, double soulsRemaining) {
        int lvl = -1;
        for (int i = 0; i < soulBracket.length; ++i) {
            if (!(soulsRemaining >= (double)soulBracket[i])) continue;
            lvl = i;
        }
        return lvl;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        tooltip.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localizeEffect("tooltip.bloodmagic.sentientSword.desc", new Object[0]))));
        tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.currentType." + this.getCurrentType(stack).func_176610_l().toLowerCase(), new Object[0]));
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        this.recalculatePowers(stack, player.func_130014_f_(), player);
        double drain = this.getDrainOfActivatedSword(stack);
        if (drain > 0.0) {
            EnumDemonWillType type = this.getCurrentType(stack);
            double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
            if (drain > soulsRemaining) {
                return false;
            }
            PlayerDemonWillHandler.consumeDemonWill(type, player, drain);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new CustomMeshDefinitionMultiWill("ItemSentientSword");
    }

    @Override
    @Nullable
    public ResourceLocation getCustomLocation() {
        return null;
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> ret = new ArrayList<String>();
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            ret.add("type=" + type.func_176610_l().toLowerCase());
        }
        return ret;
    }

    @Override
    public List<ItemStack> getRandomDemonWillDrop(EntityLivingBase killedEntity, EntityLivingBase attackingEntity, ItemStack stack, int looting) {
        ArrayList<ItemStack> soulList = new ArrayList<ItemStack>();
        if (killedEntity.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && !(killedEntity instanceof IMob)) {
            return soulList;
        }
        double willModifier = killedEntity instanceof EntitySlime ? 0.67 : 1.0;
        IDemonWill soul = (IDemonWill)ModItems.MONSTER_SOUL;
        EnumDemonWillType type = this.getCurrentType(stack);
        for (int i = 0; i <= looting; ++i) {
            if (i != 0 && !(attackingEntity.func_130014_f_().field_73012_v.nextDouble() < 0.4)) continue;
            ItemStack soulStack = soul.createWill(type.ordinal(), willModifier * (this.getDropOfActivatedSword(stack) * attackingEntity.func_130014_f_().field_73012_v.nextDouble() + this.getStaticDropOfActivatedSword(stack)) * (double)killedEntity.func_110138_aP() / 20.0);
            soulList.add(soulStack);
        }
        return soulList;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getDamageOfActivatedSword(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getAttackSpeedOfSword(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(new UUID(0L, 31818145L), "Weapon modifier", this.getHealthBonusOfSword(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(new UUID(0L, 4218052L), "Weapon modifier", this.getSpeedOfSword(stack), 2));
        }
        return multimap;
    }

    public double getDamageOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordDamage");
    }

    public void setDamageOfActivatedSword(ItemStack stack, double damage) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordDamage", damage);
    }

    public double getDrainOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordActiveDrain");
    }

    public void setDrainOfActivatedSword(ItemStack stack, double drain) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordActiveDrain", drain);
    }

    public double getStaticDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordStaticDrop");
    }

    public void setStaticDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordStaticDrop", drop);
    }

    public double getDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordDrop");
    }

    public void setDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordDrop", drop);
    }

    public double getHealthBonusOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordHealth");
    }

    public void setHealthBonusOfSword(ItemStack stack, double hp) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordHealth", hp);
    }

    public double getAttackSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordAttackSpeed");
    }

    public void setAttackSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordAttackSpeed", speed);
    }

    public double getSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordSpeed");
    }

    public void setSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordSpeed", speed);
    }

    @Override
    public boolean spawnSentientEntityOnDrop(ItemStack droppedStack, EntityPlayer player) {
        World world = player.func_130014_f_();
        if (!world.field_72995_K) {
            this.recalculatePowers(droppedStack, world, player);
            EnumDemonWillType type = this.getCurrentType(droppedStack);
            double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
            if (soulsRemaining < 1024.0) {
                return false;
            }
            PlayerDemonWillHandler.consumeDemonWill(type, player, 100.0);
            EntitySentientSpecter specterEntity = new EntitySentientSpecter(world);
            specterEntity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            world.func_72838_d((Entity)specterEntity);
            specterEntity.func_184201_a(EntityEquipmentSlot.MAINHAND, droppedStack.func_77946_l());
            specterEntity.setType(this.getCurrentType(droppedStack));
            specterEntity.setOwner(player);
            specterEntity.setTamed(true);
            return true;
        }
        return false;
    }
}

