/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.iface.ISigil;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSigilTransposition
extends ItemSigilBase {
    public ItemSigilTransposition() {
        super("transposition", 1000);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag.func_74764_b("containedBlockName") && tag.func_74764_b("containedBlockMeta")) {
            tooltip.add(" ");
            BlockStack blockStack = new BlockStack(Block.func_149684_b((String)tag.func_74779_i("containedBlockName")), tag.func_74771_c("containedBlockMeta"));
            tooltip.add(blockStack.getItemStack().func_82833_r());
        }
    }

    public String func_77653_i(ItemStack stack) {
        BlockStack blockStack;
        NBTTagCompound tag = (stack = NBTHelper.checkNBT(stack)).func_77978_p();
        if (tag.func_74764_b("containedBlockName") && tag.func_74764_b("containedBlockMeta") && (blockStack = new BlockStack((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.func_74779_i("containedBlockName"))), tag.func_74771_c("containedBlockMeta"))).getItemStack() != null && blockStack.getItemStack().func_77973_b() != null) {
            return super.func_77653_i(stack) + " (" + blockStack.getItemStack().func_82833_r() + ")";
        }
        return super.func_77653_i(stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos blockPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return EnumActionResult.FAIL;
        }
        stack = NBTHelper.checkNBT(stack);
        IBlockState state = world.func_180495_p(blockPos);
        if (!world.field_72995_K) {
            BlockStack rightClickedBlock = BlockStack.getStackFromPos(world, blockPos);
            if (BloodMagicAPI.getTranspositionBlacklist().contains(rightClickedBlock)) {
                return EnumActionResult.FAIL;
            }
            if (!(ConfigHandler.transpositionBlacklist.contains(rightClickedBlock) || !player.func_70093_af() || stack.func_77978_p().func_74764_b("containedBlockName") && stack.func_77978_p().func_74764_b("containedBlockMeta"))) {
                if (rightClickedBlock.getState().func_185903_a(player, world, blockPos) >= 0.0f && rightClickedBlock.getState().func_185887_b(world, blockPos) >= 0.0f) {
                    int cost = this.getLpUsed();
                    NBTTagCompound tileNBTTag = new NBTTagCompound();
                    String blockName = rightClickedBlock.getBlock().getRegistryName().toString();
                    byte metadata = (byte)rightClickedBlock.getMeta();
                    if (world.func_175625_s(blockPos) != null) {
                        cost *= 5;
                        world.func_175625_s(blockPos).func_189515_b(tileNBTTag);
                        if (world.func_175625_s(blockPos) instanceof TileEntityMobSpawner) {
                            cost *= 6;
                        }
                    }
                    stack.func_77978_p().func_74778_a("containedBlockName", blockName);
                    stack.func_77978_p().func_74774_a("containedBlockMeta", metadata);
                    stack.func_77978_p().func_74782_a("containedTileEntity", (NBTBase)tileNBTTag);
                    NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage(player, cost);
                    world.func_175713_t(blockPos);
                    world.func_175698_g(blockPos);
                    return EnumActionResult.SUCCESS;
                }
            } else if (stack.func_77978_p().func_74764_b("containedBlockName") && stack.func_77978_p().func_74764_b("containedBlockMeta")) {
                IBlockState iblockstate = world.func_180495_p(blockPos);
                Block block = iblockstate.func_177230_c();
                BlockStack blockToPlace = new BlockStack(Block.func_149684_b((String)stack.func_77978_p().func_74779_i("containedBlockName")), stack.func_77978_p().func_74771_c("containedBlockMeta"));
                if (!block.func_176200_f((IBlockAccess)world, blockPos)) {
                    blockPos = blockPos.func_177972_a(side);
                }
                if (!stack.func_190926_b() && player.func_175151_a(blockPos, side, stack) && world.func_190527_a(blockToPlace.getBlock(), blockPos, false, side, (Entity)player) && world.func_180501_a(blockPos, blockToPlace.getState(), 3)) {
                    blockToPlace.getBlock().func_180633_a(world, blockPos, blockToPlace.getState(), (EntityLivingBase)player, blockToPlace.getItemStack());
                    if (stack.func_77978_p().func_74764_b("containedTileEntity") && blockToPlace.getBlock().hasTileEntity(blockToPlace.getState())) {
                        NBTTagCompound tag = stack.func_77978_p().func_74775_l("containedTileEntity");
                        tag.func_74768_a("x", blockPos.func_177958_n());
                        tag.func_74768_a("y", blockPos.func_177956_o());
                        tag.func_74768_a("z", blockPos.func_177952_p());
                        world.func_175625_s(blockPos).func_145839_a(tag);
                    }
                    world.func_184138_a(blockPos, state, state, 3);
                    stack.func_77978_p().func_82580_o("containedBlockName");
                    stack.func_77978_p().func_82580_o("containedBlockMeta");
                    stack.func_77978_p().func_82580_o("containedTileEntity");
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.FAIL;
    }
}

