/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.iface.IAltarReader;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.iface.ISigil;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.client.key.IKeybindable;
import WayofTime.bloodmagic.client.key.KeyBindings;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemSigilHolding
extends ItemSigilBase
implements IKeybindable,
IAltarReader,
ISigil.Holding {
    public static final int inventorySize = 5;

    public ItemSigilHolding() {
        super("holding");
    }

    @Override
    public void onKeyPressed(ItemStack stack, EntityPlayer player, KeyBindings key, boolean showInChat) {
        if (stack == player.func_184614_ca() && stack.func_77973_b() instanceof ItemSigilHolding && key.equals((Object)KeyBindings.OPEN_HOLDING)) {
            Utils.setUUID(stack);
            player.openGui((Object)BloodMagic.instance, 5, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        int currentSlot;
        List<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
        ItemStack item = inv.get(currentSlot = ItemSigilHolding.getCurrentItemOrdinal(stack));
        if (item.func_190926_b()) {
            return displayName;
        }
        return TextHelper.localizeEffect("item.bloodmagic.sigil.holding.display", displayName, item.func_82833_r());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.sigil.holding.press", KeyBindings.OPEN_HOLDING.getKey().getDisplayName()));
        if (!stack.func_77942_o()) {
            return;
        }
        List<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(stack);
        ItemStack item = inv.get(currentSlot);
        for (int i = 0; i < 5; ++i) {
            ItemStack invStack = inv.get(i);
            if (invStack.func_190926_b()) continue;
            if (!item.func_190926_b() && invStack == item) {
                tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.sigil.holding.sigilInSlot", i + 1, "&o&n" + invStack.func_82833_r()));
                continue;
            }
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.sigil.holding.sigilInSlot", i + 1, invStack.func_82833_r()));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer(player)) {
            return EnumActionResult.FAIL;
        }
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(stack);
        List<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
        ItemStack itemUsing = inv.get(currentSlot);
        if (itemUsing.func_190926_b() || Strings.isNullOrEmpty((String)((IBindable)itemUsing.func_77973_b()).getOwnerUUID(itemUsing))) {
            return EnumActionResult.PASS;
        }
        EnumActionResult result = itemUsing.func_77973_b().func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        this.saveInventory(stack, inv);
        return result;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(stack);
        List<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
        ItemStack itemUsing = inv.get(currentSlot);
        if (itemUsing.func_190926_b() || Strings.isNullOrEmpty((String)((IBindable)itemUsing.func_77973_b()).getOwnerUUID(itemUsing))) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        itemUsing.func_77973_b().func_77659_a(world, player, hand);
        this.saveInventory(stack, inv);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @Override
    @Nonnull
    public ItemStack getHeldItem(ItemStack holdingStack, EntityPlayer player) {
        return ItemSigilHolding.getInternalInventory(holdingStack).get(ItemSigilHolding.getCurrentItemOrdinal(holdingStack));
    }

    public void saveInventory(ItemStack itemStack, List<ItemStack> inventory) {
        NBTTagCompound itemTag = itemStack.func_77978_p();
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < 5; ++i) {
            if (inventory.get(i).func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            inventory.get(i).func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        itemTag.func_74782_a("Items", (NBTBase)itemList);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (itemStack.func_77978_p() != null) {
            this.tickInternalInventory(itemStack, world, entity, itemSlot, isSelected);
        }
    }

    public void tickInternalInventory(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        List<ItemStack> inv = ItemSigilHolding.getInternalInventory(itemStack);
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = inv.get(i);
            if (stack.func_190926_b()) continue;
            stack.func_77973_b().func_77663_a(stack, world, entity, itemSlot, isSelected);
        }
    }

    public static int next(int mode) {
        int index = mode + 1;
        if (index >= 5) {
            index = 0;
        }
        return index;
    }

    public static int prev(int mode) {
        int index = mode - 1;
        if (index < 0) {
            index = 5;
        }
        return index;
    }

    private static void initModeTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack = NBTHelper.checkNBT(stack);
            stack.func_77978_p().func_74768_a("currentSigil", 5);
        }
    }

    public static ItemStack getItemStackInSlot(ItemStack itemStack, int slot) {
        if (itemStack.func_77973_b() instanceof ItemSigilHolding) {
            List<ItemStack> inv = ItemSigilHolding.getInternalInventory(itemStack);
            if (inv != null) {
                return inv.get(slot == 5 ? 4 : slot);
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public static int getCurrentItemOrdinal(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemSigilHolding) {
            ItemSigilHolding.initModeTag(stack);
            int currentSigil = stack.func_77978_p().func_74762_e("currentSigil");
            currentSigil = MathHelper.func_76125_a((int)currentSigil, (int)0, (int)4);
            return currentSigil;
        }
        return 0;
    }

    public static List<ItemStack> getInternalInventory(ItemStack stack) {
        ItemSigilHolding.initModeTag(stack);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        }
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        if (tagList.func_82582_d()) {
            return NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        }
        NonNullList inv = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound data = tagList.func_150305_b(i);
            byte j = data.func_74771_c("Slot");
            if (j < 0 || j >= inv.size()) continue;
            inv.set(j, new ItemStack(data));
        }
        return inv;
    }

    public static void cycleToNextSigil(ItemStack itemStack, int mode) {
        if (itemStack.func_77973_b() instanceof ItemSigilHolding) {
            ItemSigilHolding.initModeTag(itemStack);
            int index = mode;
            if (mode == 120 || mode == -120) {
                int currentIndex = ItemSigilHolding.getCurrentItemOrdinal(itemStack);
                ItemStack currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, currentIndex);
                if (currentItemStack.func_190926_b()) {
                    return;
                }
                if (mode < 0) {
                    index = ItemSigilHolding.next(currentIndex);
                    currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    while (currentItemStack.func_190926_b()) {
                        index = ItemSigilHolding.next(index);
                        currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    }
                } else {
                    index = ItemSigilHolding.prev(currentIndex);
                    currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    while (currentItemStack.func_190926_b()) {
                        index = ItemSigilHolding.prev(index);
                        currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    }
                }
            }
            itemStack.func_77978_p().func_74768_a("currentSigil", index);
        }
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        return Collections.emptyList();
    }
}

