/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.api.iface.ISigil;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.entity.projectile.EntityBloodLight;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import WayofTime.bloodmagic.registry.ModBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemSigilBloodLight
extends ItemSigilBase {
    public ItemSigilBloodLight() {
        super("bloodLight", 10);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.getCooldownRemainder(stack) > 0) {
            this.reduceCooldown(stack);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        RayTraceResult mop = this.func_77621_a(world, player, false);
        if (this.getCooldownRemainder(stack) > 0) {
            return super.func_77659_a(world, player, hand);
        }
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockPos = mop.func_178782_a().func_177972_a(mop.field_178784_b);
            if (world.func_175623_d(blockPos)) {
                world.func_175656_a(blockPos, ModBlocks.BLOOD_LIGHT.func_176223_P());
                if (!world.field_72995_K) {
                    NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage(player, this.getLpUsed());
                }
                this.resetCooldown(stack);
                player.func_184609_a(hand);
                return super.func_77659_a(world, player, hand);
            }
        } else {
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityBloodLight(world, (EntityLivingBase)player));
                NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage(player, this.getLpUsed());
            }
            this.resetCooldown(stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public int getCooldownRemainder(ItemStack stack) {
        return NBTHelper.checkNBT(stack).func_77978_p().func_74762_e("ticksRemaining");
    }

    public void reduceCooldown(ItemStack stack) {
        NBTHelper.checkNBT(stack).func_77978_p().func_74768_a("ticksRemaining", this.getCooldownRemainder(stack) - 1);
    }

    public void resetCooldown(ItemStack stack) {
        NBTHelper.checkNBT(stack).func_77978_p().func_74768_a("ticksRemaining", 10);
    }
}

