/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.routing;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.iface.INodeRenderer;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.routing.IMasterRoutingNode;
import WayofTime.bloodmagic.routing.IRoutingNode;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ItemNodeRouter
extends Item
implements INodeRenderer,
IVariantProvider {
    public ItemNodeRouter() {
        this.func_77655_b("bloodmagic.nodeRouter");
        this.func_77625_d(1);
        this.func_77637_a(BloodMagic.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        BlockPos coords = this.getBlockPos(stack);
        if (coords != null && tag != null) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.telepositionFocus.coords", coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        TileEntity tileHit = world.func_175625_s(pos);
        if (!(tileHit instanceof IRoutingNode)) {
            BlockPos containedPos = this.getBlockPos(stack);
            if (containedPos.equals((Object)BlockPos.field_177992_a)) return EnumActionResult.FAIL;
            this.setBlockPos(stack, BlockPos.field_177992_a);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.routing.remove", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        IRoutingNode node = (IRoutingNode)tileHit;
        BlockPos containedPos = this.getBlockPos(stack);
        if (containedPos.equals((Object)BlockPos.field_177992_a)) {
            this.setBlockPos(stack, pos);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.routing.set", new Object[0]), true);
            return EnumActionResult.SUCCESS;
        }
        TileEntity pastTile = world.func_175625_s(containedPos);
        if (!(pastTile instanceof IRoutingNode)) return EnumActionResult.FAIL;
        IRoutingNode pastNode = (IRoutingNode)pastTile;
        if (pastNode instanceof IMasterRoutingNode) {
            IMasterRoutingNode master = (IMasterRoutingNode)pastNode;
            if (!node.isMaster(master)) {
                if (!node.getMasterPos().equals((Object)BlockPos.field_177992_a)) return EnumActionResult.FAIL;
                node.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
                master.addConnection(pos, containedPos);
                master.addNodeToList(node);
                node.addConnection(containedPos);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.routing.link.master", new Object[0]), true);
                this.setBlockPos(stack, BlockPos.field_177992_a);
                return EnumActionResult.SUCCESS;
            }
            master.addConnection(pos, containedPos);
            node.addConnection(containedPos);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.routing.link.master", new Object[0]), true);
            this.setBlockPos(stack, BlockPos.field_177992_a);
            return EnumActionResult.SUCCESS;
        }
        if (node instanceof IMasterRoutingNode) {
            IMasterRoutingNode master = (IMasterRoutingNode)node;
            if (!pastNode.isMaster(master)) {
                if (!pastNode.getMasterPos().equals((Object)BlockPos.field_177992_a)) return EnumActionResult.FAIL;
                pastNode.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
                master.addConnection(pos, containedPos);
                pastNode.addConnection(pos);
                master.addNodeToList(pastNode);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.routing.link.master", new Object[0]), true);
                this.setBlockPos(stack, BlockPos.field_177992_a);
                return EnumActionResult.SUCCESS;
            }
            master.addConnection(pos, containedPos);
            pastNode.addConnection(pos);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.routing.link.master", new Object[0]), true);
            this.setBlockPos(stack, BlockPos.field_177992_a);
            return EnumActionResult.SUCCESS;
        }
        if (pastNode.getMasterPos().equals((Object)node.getMasterPos())) {
            TileEntity testTile;
            if (!pastNode.getMasterPos().equals((Object)BlockPos.field_177992_a) && (testTile = world.func_175625_s(pastNode.getMasterPos())) instanceof IMasterRoutingNode) {
                IMasterRoutingNode master = (IMasterRoutingNode)testTile;
                master.addConnection(pos, containedPos);
            }
            pastNode.addConnection(pos);
            node.addConnection(containedPos);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.routing.link.master", new Object[0]), true);
            this.setBlockPos(stack, BlockPos.field_177992_a);
            return EnumActionResult.SUCCESS;
        }
        if (pastNode.getMasterPos().equals((Object)BlockPos.field_177992_a)) {
            TileEntity tile = world.func_175625_s(node.getMasterPos());
            if (tile instanceof IMasterRoutingNode) {
                IMasterRoutingNode master = (IMasterRoutingNode)tile;
                master.addConnection(pos, containedPos);
                master.addNodeToList(pastNode);
                pastNode.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
            }
            pastNode.addConnection(pos);
            node.addConnection(containedPos);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.routing.link", new Object[0]), true);
            this.setBlockPos(stack, BlockPos.field_177992_a);
            return EnumActionResult.SUCCESS;
        }
        if (node.getMasterPos().equals((Object)BlockPos.field_177992_a)) {
            TileEntity tile = world.func_175625_s(pastNode.getMasterPos());
            if (tile instanceof IMasterRoutingNode) {
                IMasterRoutingNode master = (IMasterRoutingNode)tile;
                master.addConnection(pos, containedPos);
                master.addNodeToList(node);
                node.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
            }
            pastNode.addConnection(pos);
            node.addConnection(containedPos);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.routing.link", new Object[0]), true);
            this.setBlockPos(stack, BlockPos.field_177992_a);
            return EnumActionResult.SUCCESS;
        }
        this.setBlockPos(stack, BlockPos.field_177992_a);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)0, (Object)"type=normal"));
        return ret;
    }

    public BlockPos getBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.func_77978_p().func_74762_e("xCoord"), stack.func_77978_p().func_74762_e("yCoord"), stack.func_77978_p().func_74762_e("zCoord"));
    }

    public ItemStack setBlockPos(ItemStack stack, BlockPos pos) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound itemTag = stack.func_77978_p();
        itemTag.func_74768_a("xCoord", pos.func_177958_n());
        itemTag.func_74768_a("yCoord", pos.func_177956_o());
        itemTag.func_74768_a("zCoord", pos.func_177952_p());
        return stack;
    }
}

