/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.armour;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.item.ItemComponent;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerRepairing;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeElytra;
import WayofTime.bloodmagic.network.BloodMagicPacketHandler;
import WayofTime.bloodmagic.network.PlayerFallDistancePacketProcessor;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemLivingArmour
extends ItemArmor
implements ISpecialArmor,
IMeshProvider {
    private static Field _FLAGS = ReflectionHelper.findField(Entity.class, (String[])new String[]{"FLAGS", "field_184240_ax"});
    private static DataParameter<Byte> FLAGS = null;
    public static String[] names = new String[]{"helmet", "chest", "legs", "boots"};
    public static final boolean useSpecialArmourCalculation = true;
    public static Map<UUID, LivingArmour> armourMap = new HashMap<UUID, LivingArmour>();

    public ItemLivingArmour(EntityEquipmentSlot armorType) {
        super(ItemArmor.ArmorMaterial.IRON, 0, armorType);
        this.func_77655_b("bloodmagic.livingArmour.");
        this.func_77656_e((int)((double)this.func_77612_l() * 1.5));
        this.func_77637_a(BloodMagic.tabBloodMagic);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (stack != null && !world.field_72995_K && stack.func_77973_b() == ModItems.LIVING_ARMOUR_CHEST) {
            Utils.setUUID(stack);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (this == ModItems.LIVING_ARMOUR_CHEST || this == ModItems.LIVING_ARMOUR_HELMET || this == ModItems.LIVING_ARMOUR_BOOTS) {
            return "bloodmagic:models/armor/livingArmour_layer_1.png";
        }
        if (this == ModItems.LIVING_ARMOUR_LEGS) {
            return "bloodmagic:models/armor/livingArmour_layer_2.png";
        }
        return null;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ItemStack.func_179545_c((ItemStack)repair, (ItemStack)ItemComponent.getStack("reagentBinding"));
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack stack, DamageSource source, double damage, int slot) {
        double armourReduction = 0.0;
        double damageAmount = 0.25;
        if (this == ModItems.LIVING_ARMOUR_BOOTS || this == ModItems.LIVING_ARMOUR_HELMET) {
            damageAmount = 0.09;
        } else if (this == ModItems.LIVING_ARMOUR_LEGS) {
            damageAmount = 0.18;
        } else if (this == ModItems.LIVING_ARMOUR_CHEST) {
            damageAmount = 0.64;
        }
        double armourPenetrationReduction = 0.0;
        int maxAbsorption = 100000;
        if (source.equals(DamageSource.field_76369_e)) {
            return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
        }
        if (source.equals(DamageSource.field_76380_i)) {
            return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
        }
        if (this == ModItems.LIVING_ARMOUR_CHEST) {
            armourReduction = 0.375;
            ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack leggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (helmet.func_190926_b() || leggings.func_190926_b() || boots.func_190926_b()) {
                return new ISpecialArmor.ArmorProperties(-1, damageAmount *= armourReduction, maxAbsorption);
            }
            if (helmet.func_77973_b() instanceof ItemLivingArmour && leggings.func_77973_b() instanceof ItemLivingArmour && boots.func_77973_b() instanceof ItemLivingArmour) {
                LivingArmour armour;
                double remainder = 1.0;
                if (ItemLivingArmour.hasLivingArmour(stack) && (armour = ItemLivingArmour.getLivingArmour(stack)) != null && this.isEnabled(stack)) {
                    for (Map.Entry<String, LivingArmourUpgrade> entry : armour.upgradeMap.entrySet()) {
                        LivingArmourUpgrade upgrade = entry.getValue();
                        remainder *= 1.0 - upgrade.getArmourProtection(player, source);
                    }
                }
                armourReduction += (1.0 - remainder) * (1.0 - armourReduction);
                return new ISpecialArmor.ArmorProperties(-1, source.func_76363_c() ? 1.0 - remainder : (damageAmount *= armourReduction), maxAbsorption);
            }
        } else {
            if (source.func_76363_c()) {
                return new ISpecialArmor.ArmorProperties(-1, damageAmount * armourPenetrationReduction, maxAbsorption);
            }
            return new ISpecialArmor.ArmorProperties(-1, damageAmount, maxAbsorption);
        }
        return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (armor.func_77973_b() == ModItems.LIVING_ARMOUR_HELMET) {
            return 3;
        }
        if (armor.func_77973_b() == ModItems.LIVING_ARMOUR_CHEST) {
            return 8;
        }
        if (armor.func_77973_b() == ModItems.LIVING_ARMOUR_LEGS) {
            return 6;
        }
        if (armor.func_77973_b() == ModItems.LIVING_ARMOUR_BOOTS) {
            return 3;
        }
        return 5;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (this == ModItems.LIVING_ARMOUR_CHEST) {
            LivingArmour armour;
            EntityPlayer player;
            int preDamage = stack.func_77952_i();
            if (source.func_76363_c()) {
                return;
            }
            if (damage > this.getMaxDamage(stack) - this.getDamage(stack)) {
                if (entity.func_130014_f_().field_72995_K && entity instanceof EntityPlayer) {
                    EntityPlayer player2 = (EntityPlayer)entity;
                    SoulNetwork network = NetworkHelper.getSoulNetwork(player2);
                    network.syphonAndDamage(player2, damage * 100);
                }
                return;
            }
            stack.func_77972_a(damage, entity);
            int receivedDamage = stack.func_77952_i() - preDamage;
            if (entity instanceof EntityPlayer && LivingArmour.hasFullSet(player = (EntityPlayer)entity) && (armour = ItemLivingArmour.getLivingArmour(stack)) != null) {
                StatTrackerRepairing.incrementCounter(armour, receivedDamage);
            }
        } else {
            stack.func_77972_a(damage, entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        if (this == ModItems.LIVING_ARMOUR_CHEST) {
            LivingArmour armour = ItemLivingArmour.getLivingArmourFromStack(stack);
            for (Map.Entry<String, LivingArmourUpgrade> entry : armour.upgradeMap.entrySet()) {
                LivingArmourUpgrade upgrade = entry.getValue();
                if (upgrade == null) continue;
                if (Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)50)) {
                    StatTracker tracker = null;
                    for (StatTracker searchTracker : armour.trackerMap.values()) {
                        if (searchTracker == null || !searchTracker.providesUpgrade(upgrade.getUniqueIdentifier())) continue;
                        tracker = searchTracker;
                        break;
                    }
                    if (tracker == null) continue;
                    double progress = tracker.getProgress(armour, upgrade.getUpgradeLevel());
                    tooltip.add(TextHelper.localize("tooltip.bloodmagic.livingArmour.upgrade.progress", TextHelper.localize(upgrade.getUnlocalizedName(), new Object[0]), MathHelper.func_76125_a((int)((int)(progress * 100.0)), (int)0, (int)100)));
                    continue;
                }
                tooltip.add(TextHelper.localize("tooltip.bloodmagic.livingArmour.upgrade.level", TextHelper.localize(upgrade.getUnlocalizedName(), new Object[0]), upgrade.getUpgradeLevel() + 1));
            }
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.livingArmour.upgrade.points", armour.totalUpgradePoints, armour.maxUpgradePoints));
            if (!Keyboard.isKeyDown((int)42) || !Keyboard.isKeyDown((int)50)) {
                tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.livingArmour.extraExtraInfo", new Object[0]));
            }
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (world.field_72995_K && this == ModItems.LIVING_ARMOUR_CHEST && player instanceof EntityPlayerSP) {
            ItemStack chestStack;
            LivingArmourUpgrade upgrade;
            EntityPlayerSP spPlayer = (EntityPlayerSP)player;
            if (FLAGS == null) {
                try {
                    FLAGS = (DataParameter)_FLAGS.get(null);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (FLAGS != null && LivingArmour.hasFullSet(player) && (upgrade = ItemLivingArmour.getUpgradeFromNBT("bloodmagic.upgrade.elytra", chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) instanceof LivingArmourUpgradeElytra) {
                if (spPlayer.field_71158_b.field_78901_c && !spPlayer.field_70122_E && spPlayer.field_70181_x < 0.0 && !spPlayer.field_71075_bZ.field_75100_b) {
                    if (spPlayer.field_70181_x > -0.5) {
                        BloodMagicPacketHandler.INSTANCE.sendToServer((IMessage)new PlayerFallDistancePacketProcessor(1.0f));
                    }
                    if (!spPlayer.func_184613_cA()) {
                        byte b0 = (Byte)player.func_184212_Q().func_187225_a(FLAGS);
                        player.func_184212_Q().func_187227_b(FLAGS, (Object)((byte)(b0 | 0x80)));
                    }
                } else if (spPlayer.func_184613_cA() && !spPlayer.field_71158_b.field_78901_c && !spPlayer.field_70122_E) {
                    byte b0 = (Byte)player.func_184212_Q().func_187225_a(FLAGS);
                    player.func_184212_Q().func_187227_b(FLAGS, (Object)((byte)(b0 & 0xFFFFFF7F)));
                }
            }
        }
        if (this == ModItems.LIVING_ARMOUR_CHEST) {
            if (!ItemLivingArmour.hasLivingArmour(stack)) {
                ItemLivingArmour.setLivingArmour(stack, ItemLivingArmour.getLivingArmourFromStack(stack));
            }
            LivingArmour armour = ItemLivingArmour.getLivingArmour(stack);
            if (LivingArmour.hasFullSet(player)) {
                this.setIsEnabled(stack, true);
                armour.onTick(world, player);
            }
            this.setLivingArmour(stack, armour, false);
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        if (this == ModItems.LIVING_ARMOUR_CHEST && this.isEnabled(stack) && slot == EntityEquipmentSlot.CHEST) {
            LivingArmour armour = ItemLivingArmour.getLivingArmourFromStack(stack);
            return armour.getAttributeModifiers();
        }
        return HashMultimap.create();
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + names[3 - this.field_77881_a.func_188454_b()];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                assert (ItemLivingArmour.this.getCustomLocation() != null);
                if (stack.func_77973_b() == ModItems.LIVING_ARMOUR_HELMET) {
                    return new ModelResourceLocation(ItemLivingArmour.this.getCustomLocation(), "armour=head");
                }
                if (stack.func_77973_b() == ModItems.LIVING_ARMOUR_CHEST) {
                    return new ModelResourceLocation(ItemLivingArmour.this.getCustomLocation(), "armour=body");
                }
                if (stack.func_77973_b() == ModItems.LIVING_ARMOUR_LEGS) {
                    return new ModelResourceLocation(ItemLivingArmour.this.getCustomLocation(), "armour=leg");
                }
                return new ModelResourceLocation(ItemLivingArmour.this.getCustomLocation(), "armour=feet");
            }
        };
    }

    @Override
    public ResourceLocation getCustomLocation() {
        return new ResourceLocation("bloodmagic", "item/ItemLivingArmour");
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("armour=head");
        ret.add("armour=body");
        ret.add("armour=leg");
        ret.add("armour=feet");
        return ret;
    }

    @Nullable
    public static LivingArmour getLivingArmourFromStack(ItemStack stack) {
        NBTTagCompound livingTag = ItemLivingArmour.getArmourTag(stack);
        LivingArmour livingArmour = new LivingArmour();
        livingArmour.readFromNBT(livingTag);
        return livingArmour;
    }

    public void setLivingArmour(ItemStack stack, LivingArmour armour, boolean forceWrite) {
        NBTTagCompound livingTag = new NBTTagCompound();
        if (!forceWrite) {
            livingTag = ItemLivingArmour.getArmourTag(stack);
            armour.writeDirtyToNBT(livingTag);
        } else {
            armour.writeToNBT(livingTag);
        }
        this.setArmourTag(stack, livingTag);
    }

    public static NBTTagCompound getArmourTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74775_l("livingArmour");
    }

    public void setArmourTag(ItemStack stack, NBTTagCompound livingTag) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74782_a("livingArmour", (NBTBase)livingTag);
    }

    public static LivingArmourUpgrade getUpgrade(String uniqueIdentifier, ItemStack stack) {
        if (!ItemLivingArmour.hasLivingArmour(stack)) {
            ItemLivingArmour.setLivingArmour(stack, ItemLivingArmour.getLivingArmourFromStack(stack));
        }
        LivingArmour armour = ItemLivingArmour.getLivingArmour(stack);
        for (Map.Entry<String, LivingArmourUpgrade> entry : armour.upgradeMap.entrySet()) {
            if (!entry.getKey().equals(uniqueIdentifier)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static LivingArmourUpgrade getUpgradeFromNBT(String uniqueIdentifier, ItemStack stack) {
        LivingArmour armour = ItemLivingArmour.getLivingArmourFromStack(stack);
        for (Map.Entry<String, LivingArmourUpgrade> entry : armour.upgradeMap.entrySet()) {
            if (!entry.getKey().equals(uniqueIdentifier)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean hasLivingArmour(ItemStack stack) {
        UUID uuid = Utils.getUUID(stack);
        return uuid != null && armourMap.containsKey(uuid);
    }

    @Nullable
    public static LivingArmour getLivingArmour(ItemStack stack) {
        UUID uuid = Utils.getUUID(stack);
        return armourMap.get(uuid);
    }

    public static void setLivingArmour(ItemStack stack, LivingArmour armour) {
        if (!Utils.hasUUID(stack)) {
            Utils.setUUID(stack);
        }
        UUID uuid = Utils.getUUID(stack);
        armourMap.put(uuid, armour);
    }

    public static boolean hasUpgrade(String id, ItemStack stack) {
        if (!ItemLivingArmour.hasLivingArmour(stack)) {
            ItemLivingArmour.setLivingArmour(stack, ItemLivingArmour.getLivingArmourFromStack(stack));
        }
        LivingArmour armour = ItemLivingArmour.getLivingArmour(stack);
        return armour.upgradeMap.containsKey(id);
    }

    public void setIsEnabled(ItemStack stack, boolean bool) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74757_a("enabled", bool);
    }

    public boolean isEnabled(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74767_n("enabled");
    }

    public void setIsElytra(ItemStack stack, boolean bool) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74757_a("elytra", bool);
    }

    public boolean isElytra(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74767_n("elytra");
    }
}

