/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.item.ItemBindableBase;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTelepositionFocus
extends ItemBindableBase
implements IVariantProvider {
    public static String[] names = new String[]{"weak", "enhanced", "reinforced", "demonic"};

    public ItemTelepositionFocus() {
        this.func_77655_b("bloodmagic.focus.");
        this.func_77637_a(BloodMagic.tabBloodMagic);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + names[stack.func_77952_i()];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        for (int i = 0; i < names.length; ++i) {
            list.add((Object)new ItemStack(id, 1, i));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult mop;
        if (player.func_70093_af() && (mop = this.func_77621_a(world, player, false)) != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.setBlockPos(player.func_184586_b(hand), world, mop.func_178782_a());
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localize("tooltip.bloodmagic.telepositionFocus." + names[stack.func_77952_i()], new Object[0]))));
        super.func_77624_a(stack, player, tooltip, advanced);
        if (!stack.func_77942_o()) {
            return;
        }
        stack = NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        BlockPos coords = this.getBlockPos(stack);
        if (coords != null && tag != null) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.telepositionFocus.coords", coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()));
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.telepositionFocus.dimension", tag.func_74762_e("dimensionId")));
        }
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)0, (Object)"type=weak"));
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)1, (Object)"type=enhanced"));
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)2, (Object)"type=reinforced"));
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)3, (Object)"type=demonic"));
        return ret;
    }

    public World getWorld(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return DimensionManager.getWorld((int)stack.func_77978_p().func_74762_e("dimensionId"));
    }

    public BlockPos getBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.func_77978_p().func_74762_e("xCoord"), stack.func_77978_p().func_74762_e("yCoord"), stack.func_77978_p().func_74762_e("zCoord"));
    }

    public ItemStack setBlockPos(ItemStack stack, World world, BlockPos pos) {
        stack = NBTHelper.checkNBT(stack);
        NBTTagCompound itemTag = stack.func_77978_p();
        itemTag.func_74768_a("xCoord", pos.func_177958_n());
        itemTag.func_74768_a("yCoord", pos.func_177956_o());
        itemTag.func_74768_a("zCoord", pos.func_177952_p());
        itemTag.func_74768_a("dimensionId", world.field_73011_w.getDimension());
        return stack;
    }
}

