/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPotionFlask
extends Item
implements IMeshProvider {
    public ItemPotionFlask() {
        this.func_77655_b("bloodmagic.potionFlask");
        this.func_77637_a(BloodMagic.tabBloodMagic);
        this.func_77625_d(1);
        this.func_77656_e(8);
        this.setNoRepair();
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        EntityPlayer player = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        int remainingUses = stack.func_77958_k() - stack.func_77952_i();
        if (remainingUses <= 0) {
            NBTHelper.checkNBT(stack);
            stack.func_77978_p().func_74757_a("empty", true);
            return stack;
        }
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            stack.func_77964_b(stack.func_77952_i() + 1);
        }
        if (!world.field_72995_K) {
            for (PotionEffect potioneffect : PotionUtils.func_185189_a((ItemStack)stack)) {
                entityLiving.func_70690_d(new PotionEffect(potioneffect));
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        int remainingUses = stack.func_77958_k() - stack.func_77952_i();
        if (remainingUses > 0 || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("empty")) {
            return EnumActionResult.PASS;
        }
        RayTraceResult trace = this.func_77621_a(world, player, true);
        if (trace.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(trace.func_178782_a()).func_185904_a() == Material.field_151586_h) {
            world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            player.func_184611_a(hand, new ItemStack((Item)this));
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int remainingUses = stack.func_77958_k() - stack.func_77952_i();
        if (remainingUses <= 0) {
            NBTHelper.checkNBT(stack);
            stack.func_77978_p().func_74757_a("empty", true);
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        PotionUtils.func_185182_a((ItemStack)stack, tooltip, (float)1.0f);
        tooltip.add("");
        tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.potion.uses", stack.func_77958_k() - stack.func_77952_i()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                boolean full = true;
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("empty")) {
                    full = false;
                }
                return new ModelResourceLocation(new ResourceLocation("bloodmagic", "item/" + ItemPotionFlask.this.getRegistryName().func_110623_a()), "full=" + (full ? "true" : "false"));
            }
        };
    }

    @Override
    @Nullable
    public ResourceLocation getCustomLocation() {
        return null;
    }

    @Override
    public List<String> getVariants() {
        return Lists.newArrayList((Object[])new String[]{"full=true", "full=false"});
    }
}

