/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDiscreteDemonWill;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ItemDemonCrystal
extends Item
implements IDiscreteDemonWill,
IVariantProvider {
    private static ArrayList<String> names = new ArrayList();
    public static final String CRYSTAL_DEFAULT = "crystalDefault";
    public static final String CRYSTAL_CORROSIVE = "crystalCorrosive";
    public static final String CRYSTAL_VENGEFUL = "crystalVengeful";
    public static final String CRYSTAL_DESTRUCTIVE = "crystalDestructive";
    public static final String CRYSTAL_STEADFAST = "crystalSteadfast";

    public ItemDemonCrystal() {
        this.func_77655_b("bloodmagic.demonCrystal.");
        this.func_77627_a(true);
        this.func_77637_a(BloodMagic.tabBloodMagic);
        this.buildItemList();
    }

    private void buildItemList() {
        names.add(0, CRYSTAL_DEFAULT);
        names.add(1, CRYSTAL_CORROSIVE);
        names.add(2, CRYSTAL_DESTRUCTIVE);
        names.add(3, CRYSTAL_VENGEFUL);
        names.add(4, CRYSTAL_STEADFAST);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + names.get(stack.func_77952_i());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        for (int i = 0; i < names.size(); ++i) {
            list.add((Object)new ItemStack(id, 1, i));
        }
    }

    public static ItemStack getStack(String name) {
        return new ItemStack(ModItems.ITEM_DEMON_CRYSTAL, 1, names.indexOf(name));
    }

    @Override
    public double getWill(ItemStack willStack) {
        return this.getDiscretization(willStack) * (double)willStack.func_190916_E();
    }

    @Override
    public double drainWill(ItemStack willStack, double drainAmount) {
        double discretization = this.getDiscretization(willStack);
        int drainedNumber = (int)Math.floor(Math.min((double)willStack.func_190916_E() * discretization, drainAmount) / discretization);
        if (drainedNumber > 0) {
            willStack.func_190918_g(drainedNumber);
            return (double)drainedNumber * discretization;
        }
        return 0.0;
    }

    @Override
    public double getDiscretization(ItemStack willStack) {
        return 50.0;
    }

    @Override
    public EnumDemonWillType getType(ItemStack willStack) {
        return EnumDemonWillType.values()[MathHelper.func_76125_a((int)willStack.func_77960_j(), (int)0, (int)(EnumDemonWillType.values().length - 1))];
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        for (String name : names) {
            ret.add((Pair<Integer, String>)new ImmutablePair((Object)names.indexOf(name), (Object)("type=" + name)));
        }
        return ret;
    }

    public static ArrayList<String> getNames() {
        return names;
    }
}

