/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.iface.IActivatable;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.client.mesh.CustomMeshDefinitionActivatable;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoundSword
extends ItemSword
implements IBindable,
IActivatable,
IMeshProvider {
    public ItemBoundSword() {
        super(ModItems.BOUND_TOOL_MATERIAL);
        this.func_77655_b("bloodmagic.bound.sword");
        this.func_77637_a(BloodMagic.tabBloodMagic);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.setActivatedState(stack, !this.getActivated(stack));
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (Strings.isNullOrEmpty((String)this.getOwnerUUID(stack))) {
            this.setActivatedState(stack, false);
            return;
        }
        if (entity instanceof EntityPlayer && this.getActivated(stack) && world.func_82737_E() % 80L == 0L) {
            NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage((EntityPlayer)entity, 20);
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState block, BlockPos pos, EntityLivingBase entityLiving) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)Utils.setUnbreakable(new ItemStack(itemIn)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        if (TextHelper.canTranslate("tooltip.bloodmagic.bound.sword.desc")) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.bound.sword.desc", new Object[0]));
        }
        tooltip.add(TextHelper.localize("tooltip.bloodmagic." + (this.getActivated(stack) ? "activated" : "deactivated"), new Object[0]));
        if (!Strings.isNullOrEmpty((String)this.getOwnerUUID(stack))) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.currentOwner", PlayerHelper.getUsernameFromStack(stack)));
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getActivated(stack) ? 8.0 : 2.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, 0));
        }
        return multimap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new CustomMeshDefinitionActivatable("ItemBoundSword");
    }

    @Override
    @Nullable
    public ResourceLocation getCustomLocation() {
        return null;
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("active=true");
        ret.add("active=false");
        return ret;
    }

    @Override
    public boolean onBind(EntityPlayer player, ItemStack stack) {
        return true;
    }

    @Override
    public String getOwnerName(ItemStack stack) {
        return stack != null ? NBTHelper.checkNBT(stack).func_77978_p().func_74779_i("ownerNAME") : null;
    }

    @Override
    public String getOwnerUUID(ItemStack stack) {
        return stack != null ? NBTHelper.checkNBT(stack).func_77978_p().func_74779_i("ownerUUID") : null;
    }

    @Override
    public boolean getActivated(ItemStack stack) {
        return stack != null && NBTHelper.checkNBT(stack).func_77978_p().func_74767_n("activated");
    }

    @Override
    public ItemStack setActivatedState(ItemStack stack, boolean activated) {
        if (stack != null) {
            NBTHelper.checkNBT(stack).func_77978_p().func_74757_a("activated", activated);
            return stack;
        }
        return null;
    }
}

