/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.ItemStackWrapper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.client.mesh.CustomMeshDefinitionActivatable;
import WayofTime.bloodmagic.item.ItemBoundTool;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoundAxe
extends ItemBoundTool
implements IMeshProvider {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap});

    public ItemBoundAxe() {
        super("axe", 7.0f, EFFECTIVE_ON);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState block, BlockPos pos, EntityLivingBase entityLiving) {
        return true;
    }

    @Override
    protected void onBoundRelease(ItemStack stack, World world, EntityPlayer player, int charge) {
        if (world.field_72995_K) {
            return;
        }
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        int fortuneLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        int range = charge / 6;
        HashMultiset drops = HashMultiset.create();
        BlockPos playerPos = player.func_180425_c();
        for (int i = -range; i <= range; ++i) {
            for (int j = 0; j <= 2 * range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    float strengthVsBlock;
                    BlockEvent.BreakEvent event;
                    BlockPos blockPos = playerPos.func_177982_a(i, j, k);
                    BlockStack blockStack = BlockStack.getStackFromPos(world, blockPos);
                    if (blockStack.getBlock().isAir(blockStack.getState(), (IBlockAccess)world, blockPos) || blockStack.getState().func_185904_a() != Material.field_151575_d && !EFFECTIVE_ON.contains(blockStack.getBlock()) || MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(world, blockPos, blockStack.getState(), player))) || event.getResult() == Event.Result.DENY || blockStack.getBlock().func_176195_g(blockStack.getState(), world, blockPos) == -1.0f || !((strengthVsBlock = this.func_150893_a(stack, blockStack.getState())) > 1.1f) && (!(blockStack.getBlock() instanceof BlockLeaves) || !world.canMineBlockBody(player, blockPos))) continue;
                    if (silkTouch && blockStack.getBlock().canSilkHarvest(world, blockPos, world.func_180495_p(blockPos), player)) {
                        drops.add((Object)new ItemStackWrapper(blockStack));
                    } else {
                        List itemDrops = blockStack.getBlock().getDrops((IBlockAccess)world, blockPos, world.func_180495_p(blockPos), fortuneLvl);
                        for (ItemStack stacks : itemDrops) {
                            drops.add((Object)ItemStackWrapper.getHolder(stacks));
                        }
                    }
                    world.func_175698_g(blockPos);
                }
            }
        }
        NetworkHelper.getSoulNetwork(player).syphonAndDamage(player, (int)((double)(charge * charge * charge) / 2.7));
        world.func_72876_a((Entity)player, (double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), 0.1f, false);
        ItemBoundAxe.dropStacks((Multiset<ItemStackWrapper>)drops, world, playerPos.func_177982_a(0, 1, 0));
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getActivated(stack) ? 11.0 : 2.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.0, 0));
        }
        return multimap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new CustomMeshDefinitionActivatable("ItemBoundAxe");
    }

    @Override
    @Nullable
    public ResourceLocation getCustomLocation() {
        return null;
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("active=true");
        ret.add("active=false");
        return ret;
    }
}

