/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.orb.BloodOrb;
import WayofTime.bloodmagic.api.orb.IBloodOrb;
import WayofTime.bloodmagic.api.registry.OrbRegistry;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.item.ItemBindableBase;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBloodOrb
extends ItemBindableBase
implements IBloodOrb,
IBindable {
    public ItemBloodOrb() {
        this.func_77655_b("bloodmagic.orb.");
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + OrbRegistry.getOrb(stack.func_77952_i()).getName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        for (int i = 0; i < OrbRegistry.getSize(); ++i) {
            list.add((Object)new ItemStack(id, 1, i));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world == null) {
            return super.func_77659_a(world, player, hand);
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        if (PlayerHelper.isFakePlayer(player)) {
            return super.func_77659_a(world, player, hand);
        }
        if (!stack.func_77942_o()) {
            return super.func_77659_a(world, player, hand);
        }
        if (Strings.isNullOrEmpty((String)this.getOwnerUUID(stack))) {
            return super.func_77659_a(world, player, hand);
        }
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        if (this.getOwnerUUID(stack).equals(PlayerHelper.getUsernameFromPlayer(player))) {
            NetworkHelper.setMaxOrb(NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)), this.getOrbLevel(stack.func_77952_i()));
        }
        NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).add(200, this.getMaxEssence(stack.func_77952_i()));
        NetworkHelper.getSoulNetwork(player).hurtPlayer(player, 200.0f);
        return super.func_77659_a(world, player, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.orb.desc", new Object[0]));
        if (advanced) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.orb.owner", this.getOrb(stack.func_77952_i()).getOwner()));
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @Override
    public boolean onBind(EntityPlayer player, ItemStack stack) {
        return true;
    }

    @Override
    public BloodOrb getOrb(int meta) {
        return OrbRegistry.getOrb(meta);
    }

    @Override
    public int getMaxEssence(int meta) {
        return OrbRegistry.getOrb(meta).getCapacity();
    }

    @Override
    public int getOrbLevel(int meta) {
        return OrbRegistry.getOrb(meta).getTier();
    }
}

