/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.altar.BloodAltar;
import WayofTime.bloodmagic.api.altar.AltarComponent;
import WayofTime.bloodmagic.api.altar.EnumAltarTier;
import WayofTime.bloodmagic.api.altar.IAltarManipulator;
import WayofTime.bloodmagic.api.altar.IBloodAltar;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.block.BlockAltar;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.NumeralHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ItemAltarMaker
extends Item
implements IAltarManipulator,
IVariantProvider {
    private EnumAltarTier tierToBuild = EnumAltarTier.ONE;

    public ItemAltarMaker() {
        this.func_77655_b("bloodmagic.altarMaker");
        this.func_77637_a(BloodMagic.tabBloodMagic);
        this.func_77625_d(1);
        this.func_77664_n();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.currentTier", stack.func_77978_p().func_74762_e("currentTier") + 1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            ChatUtil.sendNoSpam(player, TextHelper.localizeEffect("chat.bloodmagic.altarMaker.creativeOnly", new Object[0]));
            return super.func_77659_a(world, player, hand);
        }
        stack = NBTHelper.checkNBT(stack);
        if (player.func_70093_af()) {
            if (stack.func_77978_p().func_74762_e("currentTier") >= EnumAltarTier.MAXTIERS - 1) {
                stack.func_77978_p().func_74768_a("currentTier", 0);
            } else {
                stack.func_77978_p().func_74768_a("currentTier", stack.func_77978_p().func_74762_e("currentTier") + 1);
            }
            this.setTierToBuild(EnumAltarTier.values()[stack.func_77978_p().func_74762_e("currentTier")]);
            ChatUtil.sendNoSpam(player, TextHelper.localizeEffect("chat.bloodmagic.altarMaker.setTier", NumeralHelper.toRoman(stack.func_77978_p().func_74762_e("currentTier") + 1)));
            return super.func_77659_a(world, player, hand);
        }
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        if (rayTrace == null || rayTrace.field_72313_a == RayTraceResult.Type.MISS || rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
            return super.func_77659_a(world, player, hand);
        }
        if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(rayTrace.func_178782_a()).func_177230_c() instanceof BlockAltar) {
            ChatUtil.sendNoSpam(player, TextHelper.localizeEffect("chat.bloodmagic.altarMaker.building", NumeralHelper.toRoman(this.tierToBuild.toInt())));
            this.buildAltar(world, rayTrace.func_178782_a());
            IBlockState state = world.func_180495_p(rayTrace.func_178782_a());
            world.func_184138_a(rayTrace.func_178782_a(), state, state, 3);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)0, (Object)"type=altarmaker"));
        return ret;
    }

    public void setTierToBuild(EnumAltarTier tierToBuild) {
        this.tierToBuild = tierToBuild;
    }

    public void buildAltar(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (this.tierToBuild == EnumAltarTier.ONE) {
            return;
        }
        for (AltarComponent altarComponent : this.tierToBuild.getAltarComponents()) {
            BlockPos componentPos = pos.func_177971_a((Vec3i)altarComponent.getOffset());
            Block blockForComponent = Utils.getBlockForComponent(altarComponent.getComponent());
            world.func_180501_a(componentPos, blockForComponent.func_176223_P(), 3);
        }
        ((IBloodAltar)world.func_175625_s(pos)).checkTier();
    }

    public String destroyAltar(EntityPlayer player) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return "";
        }
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        BlockPos pos = rayTrace.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        EnumAltarTier altarTier = BloodAltar.getAltarTier(world, pos);
        if (altarTier.equals((Object)EnumAltarTier.ONE)) {
            return "" + altarTier.toInt();
        }
        for (AltarComponent altarComponent : altarTier.getAltarComponents()) {
            BlockPos componentPos = pos.func_177971_a((Vec3i)altarComponent.getOffset());
            IBlockState componentState = world.func_180495_p(pos);
            world.func_175698_g(componentPos);
            world.func_184138_a(componentPos, componentState, componentState, 3);
        }
        world.func_184138_a(pos, state, state, 3);
        return String.valueOf(altarTier.toInt());
    }
}

