/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compress;

import WayofTime.bloodmagic.api.compress.CompressionHandler;
import WayofTime.bloodmagic.api.compress.CompressionRegistry;
import WayofTime.bloodmagic.compress.StorageBlockCraftingManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AdvancedCompressionHandler
extends CompressionHandler {
    @Override
    public ItemStack compressInventory(ItemStack[] inv, World world) {
        return this.test(inv, true, world);
    }

    public ItemStack test(ItemStack[] inv, boolean doDrain, World world) {
        for (ItemStack invStack : inv) {
            if (invStack.func_190926_b()) continue;
            for (int i = 2; i <= 3; ++i) {
                ItemStack stack = AdvancedCompressionHandler.getRecipe(invStack, world, i);
                if (stack.func_190926_b()) continue;
                int threshold = CompressionRegistry.getItemThreshold(invStack);
                int needed = i * i;
                int neededLeft = this.iterateThroughInventory(invStack, threshold + invStack.func_77976_d() - needed, inv, needed, false);
                if (neededLeft > 0) continue;
                this.iterateThroughInventory(invStack, 0, inv, needed, true);
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public int iterateThroughInventory(ItemStack required, int kept, ItemStack[] inv, int needed, boolean doDrain) {
        int i = -1;
        for (ItemStack invStack : inv) {
            int remainingFromStack;
            ++i;
            if (invStack.func_190926_b() || !invStack.func_77969_a(required) || !(invStack.func_77978_p() == null ? required.func_77978_p() == null : invStack.func_77978_p().equals((Object)required.func_77978_p()))) continue;
            int stackSize = invStack.func_190916_E();
            int used = 0;
            if (kept > 0) {
                remainingFromStack = Math.max(stackSize - kept, 0);
                used += stackSize - remainingFromStack;
            }
            if ((kept -= used) <= 0 && needed > 0) {
                remainingFromStack = Math.max(stackSize - used - needed, 0);
                if (doDrain) {
                    invStack.func_190920_e(remainingFromStack + used);
                    if (invStack.func_190926_b()) {
                        inv[i] = ItemStack.field_190927_a;
                    }
                }
                needed -= stackSize - used - remainingFromStack;
            }
            if (needed > 0) continue;
            return 0;
        }
        return needed;
    }

    public static boolean isResultStackReversible(ItemStack stack, int gridSize, World world) {
        if (stack.func_190926_b()) {
            return false;
        }
        InventoryCrafting inventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 2, 2);
        inventory.func_70299_a(0, stack);
        ItemStack returnStack = StorageBlockCraftingManager.getInstance().findMatchingRecipe(inventory, world);
        if (returnStack.func_190926_b()) {
            return false;
        }
        ItemStack compressedStack = ItemStack.field_190927_a;
        switch (gridSize) {
            case 2: {
                compressedStack = AdvancedCompressionHandler.get22Recipe(returnStack, world);
                break;
            }
            case 3: {
                compressedStack = AdvancedCompressionHandler.get33Recipe(returnStack, world);
            }
        }
        return !compressedStack.func_190926_b() && CompressionRegistry.areItemStacksEqual(stack, compressedStack);
    }

    public static ItemStack getRecipe(ItemStack stack, World world, int gridSize) {
        InventoryCrafting inventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, gridSize, gridSize);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, stack);
        }
        return StorageBlockCraftingManager.getInstance().findMatchingRecipe(inventory, world);
    }

    public static boolean has22Recipe(ItemStack stack, World world) {
        return !AdvancedCompressionHandler.get22Recipe(stack, world).func_190926_b();
    }

    public static ItemStack get22Recipe(ItemStack stack, World world) {
        return AdvancedCompressionHandler.getRecipe(stack, world, 2);
    }

    public static boolean has33Recipe(ItemStack stack, World world) {
        return !AdvancedCompressionHandler.get33Recipe(stack, world).func_190926_b();
    }

    public static ItemStack get33Recipe(ItemStack stack, World world) {
        return AdvancedCompressionHandler.getRecipe(stack, world, 3);
    }
}

