/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compat.jei.forge;

import WayofTime.bloodmagic.api.recipe.TartaricForgeRecipe;
import WayofTime.bloodmagic.compat.jei.BloodMagicPlugin;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.item.ItemStack;

public class TartaricForgeRecipeJEI
extends BlankRecipeWrapper {
    private TartaricForgeRecipe recipe;
    private List<ItemStack> validGems = new ArrayList<ItemStack>();

    public TartaricForgeRecipeJEI(TartaricForgeRecipe recipe) {
        this.recipe = recipe;
        for (DefaultWill will : DefaultWill.values()) {
            if (!(will.minSouls >= recipe.getMinimumSouls())) continue;
            this.validGems.add(will.willStack);
        }
    }

    public void getIngredients(IIngredients ingredients) {
        List expandedInputs = BloodMagicPlugin.jeiHelper.getStackHelper().expandRecipeItemStackInputs(this.recipe.getInput());
        expandedInputs.add(this.validGems);
        ingredients.setInputLists(ItemStack.class, expandedInputs);
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.getRecipeOutput());
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> ret = new ArrayList<String>();
        if (mouseX >= 40 && mouseX <= 60 && mouseY >= 21 && mouseY <= 34) {
            ret.add(TextHelper.localize("jei.bloodmagic.recipe.minimumSouls", this.recipe.getMinimumSouls()));
            ret.add(TextHelper.localize("jei.bloodmagic.recipe.soulsDrained", this.recipe.getSoulsDrained()));
            return ret;
        }
        return null;
    }

    public TartaricForgeRecipe getRecipe() {
        return this.recipe;
    }

    public List<ItemStack> getValidGems() {
        return this.validGems;
    }

    public static enum DefaultWill {
        SOUL(new ItemStack(ModItems.MONSTER_SOUL, 1, 0), 64.0),
        PETTY(new ItemStack(ModItems.SOUL_GEM, 1, 0), 64.0),
        LESSER(new ItemStack(ModItems.SOUL_GEM, 1, 1), 256.0),
        COMMON(new ItemStack(ModItems.SOUL_GEM, 1, 2), 1024.0),
        GREATER(new ItemStack(ModItems.SOUL_GEM, 1, 3), 4096.0),
        GRAND(new ItemStack(ModItems.SOUL_GEM, 1, 4), 16384.0);

        public final ItemStack willStack;
        public final double minSouls;

        private DefaultWill(ItemStack willStack, double minSouls) {
            this.willStack = willStack;
            this.minSouls = minSouls;
        }
    }
}

