/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.registry.ImperfectRitualRegistry;
import WayofTime.bloodmagic.api.registry.RitualRegistry;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.imperfect.ImperfectRitual;
import WayofTime.bloodmagic.api.util.helper.RitualHelper;
import WayofTime.bloodmagic.block.base.BlockEnum;
import WayofTime.bloodmagic.block.enums.EnumRitualController;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.tile.TileImperfectRitualStone;
import WayofTime.bloodmagic.tile.TileMasterRitualStone;
import amerifrance.guideapi.api.IGuideLinked;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Optional.Interface(modid="guideapi", iface="amerifrance.guideapi.api.IGuideLinked")
public class BlockRitualController
extends BlockEnum<EnumRitualController>
implements IVariantProvider,
IGuideLinked {
    public BlockRitualController() {
        super(Material.field_151576_e, EnumRitualController.class);
        this.func_149663_c("bloodmagic.stone.ritual.");
        this.func_149647_a(BloodMagic.tabBloodMagic);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (state.func_177229_b(this.getProperty()) != EnumRitualController.IMPERFECT && tile instanceof TileMasterRitualStone) {
            if (heldItem.func_77973_b() == ModItems.ACTIVATION_CRYSTAL) {
                IBindable bindable = (IBindable)heldItem.func_77973_b();
                if (Strings.isNullOrEmpty((String)bindable.getOwnerName(heldItem))) {
                    return false;
                }
                String key = RitualHelper.getValidRitual(world, pos);
                EnumFacing direction = RitualHelper.getDirectionOfRitual(world, pos, key);
                if (!key.isEmpty() && direction != null && RitualHelper.checkValidRitual(world, pos, key, direction)) {
                    if (((TileMasterRitualStone)tile).activateRitual(heldItem, player, RitualRegistry.getRitualForId(key))) {
                        ((TileMasterRitualStone)tile).setDirection(direction);
                        if (state.func_177229_b(this.getProperty()) == EnumRitualController.INVERTED) {
                            ((TileMasterRitualStone)tile).setInverted(true);
                        }
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.ritual.notValid", new Object[0]), true);
                }
            }
        } else if (state.func_177229_b(this.getProperty()) == EnumRitualController.IMPERFECT && tile instanceof TileImperfectRitualStone) {
            IBlockState determinerState = world.func_180495_p(pos.func_177984_a());
            BlockStack determiner = new BlockStack(determinerState.func_177230_c(), determinerState.func_177230_c().func_176201_c(determinerState));
            return ((TileImperfectRitualStone)tile).performRitual(world, pos, ImperfectRitualRegistry.getRitualForBlock(determiner), player);
        }
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (this.func_176201_c(state) == 0 && tile instanceof TileMasterRitualStone) {
            ((TileMasterRitualStone)tile).stopRitual(Ritual.BreakType.BREAK_MRS);
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone) {
            ((TileMasterRitualStone)tile).stopRitual(Ritual.BreakType.EXPLOSION);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return state.func_177229_b(this.getProperty()) != EnumRitualController.IMPERFECT ? new TileMasterRitualStone() : new TileImperfectRitualStone();
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        for (int i = 0; i < ((EnumRitualController[])this.getTypes()).length; ++i) {
            ret.add((Pair<Integer, String>)new ImmutablePair((Object)i, (Object)("type=" + (Object)((Object)((EnumRitualController[])this.getTypes())[i]))));
        }
        return ret;
    }

    @Nullable
    public ResourceLocation getLinkedEntry(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        ImperfectRitual imperfectRitual;
        IBlockState state = world.func_180495_p(pos);
        if (((EnumRitualController)((Object)state.func_177229_b(this.getProperty()))).equals((Object)EnumRitualController.MASTER)) {
            TileMasterRitualStone mrs = (TileMasterRitualStone)world.func_175625_s(pos);
            if (mrs == null || mrs.getCurrentRitual() == null) {
                return null;
            }
            return new ResourceLocation("bloodmagic", "ritual_" + mrs.getCurrentRitual().getName());
        }
        if (((EnumRitualController)((Object)state.func_177229_b(this.getProperty()))).equals((Object)EnumRitualController.IMPERFECT) && (imperfectRitual = ImperfectRitualRegistry.getRitualForBlock(BlockStack.getStackFromPos(world, pos.func_177984_a()))) != null) {
            return new ResourceLocation("bloodmagic", "ritual_" + imperfectRitual.getName());
        }
        return null;
    }
}

