/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.block.base.BlockInteger;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.tile.TileBloodTank;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BlockBloodTank
extends BlockInteger
implements IVariantProvider {
    public static final AxisAlignedBB BOX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.8, 0.75);

    public BlockBloodTank() {
        super(Material.field_151573_f, TileBloodTank.CAPACITIES.length - 1, "tier");
        this.func_149663_c("bloodmagic.bloodTank");
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(BloodMagic.tabBloodMagic);
        this.func_149713_g(0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BOX;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return BOX;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileBloodTank fluidHandler;
        ItemStack held = player.func_184586_b(hand);
        FluidActionResult result = FluidUtil.interactWithFluidHandler((ItemStack)held, (IFluidHandler)(fluidHandler = (TileBloodTank)world.func_175625_s(blockPos)).getTank(), (EntityPlayer)player);
        if (result.isSuccess()) {
            player.func_184611_a(hand, result.getResult());
            world.func_175664_x(blockPos);
            world.func_175666_e(blockPos, (Block)this);
            world.markAndNotifyBlock(blockPos, world.func_175726_f(blockPos), state, state, 3);
            return true;
        }
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_176226_b(worldIn, pos, state, 0);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState blockState, int fortune) {
        ArrayList list = Lists.newArrayList();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBloodTank) {
            TileBloodTank bloodTank = (TileBloodTank)tile;
            ItemStack drop = new ItemStack((Block)this, 1, bloodTank.func_145832_p());
            NBTTagCompound tag = new NBTTagCompound();
            if (bloodTank.getTank().getFluid() != null) {
                bloodTank.getTank().getFluid().writeToNBT(tag);
            }
            drop.func_77982_d(tag);
            list.add(drop);
        }
        return list;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState blockState, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBloodTank) {
            TileBloodTank bloodTank = (TileBloodTank)tile;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                bloodTank.getTank().setFluid(fluidStack);
            }
        }
        world.func_175664_x(pos);
        world.func_175666_e(pos, (Block)this);
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), blockState, blockState, 3);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBloodTank) {
            FluidStack fluidStack = ((TileBloodTank)tile).getTank().getFluid();
            return fluidStack == null || fluidStack.amount <= 0 ? 0 : fluidStack.getFluid().getLuminosity(fluidStack);
        }
        return super.getLightValue(state, world, pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBloodTank) {
            return ((TileBloodTank)tile).getComparatorOutput();
        }
        return 0;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState blockState) {
        return new TileBloodTank(this.func_176201_c(blockState));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        for (int i = 0; i < TileBloodTank.CAPACITIES.length; ++i) {
            ret.add((Pair<Integer, String>)new ImmutablePair((Object)i, (Object)"inventory"));
        }
        return ret;
    }
}

