/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.altar.BloodAltar;
import WayofTime.bloodmagic.api.altar.EnumAltarComponent;
import WayofTime.bloodmagic.api.altar.IAltarManipulator;
import WayofTime.bloodmagic.api.altar.IBloodAltar;
import WayofTime.bloodmagic.api.iface.IAltarReader;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.iface.IDocumentedBlock;
import WayofTime.bloodmagic.api.orb.IBloodOrb;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.block.BlockBloodStoneBrick;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.Utils;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BlockAltar
extends Block
implements IVariantProvider,
IDocumentedBlock {
    public BlockAltar() {
        super(Material.field_151576_e);
        this.func_149663_c("bloodmagic.altar");
        this.func_149647_a(BloodMagic.tabBloodMagic);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return 0;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileAltar) {
            TileAltar altar = (TileAltar)tile;
            ItemStack orbStack = altar.func_70301_a(0);
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockBloodStoneBrick) {
                if (orbStack.func_77973_b() instanceof IBloodOrb && orbStack.func_77973_b() instanceof IBindable) {
                    IBloodOrb bloodOrb = (IBloodOrb)orbStack.func_77973_b();
                    IBindable bindable = (IBindable)orbStack.func_77973_b();
                    if (!Strings.isNullOrEmpty((String)bindable.getOwnerUUID(orbStack))) {
                        SoulNetwork soulNetwork = NetworkHelper.getSoulNetwork(bindable.getOwnerUUID(orbStack));
                        int maxEssence = bloodOrb.getMaxEssence(orbStack.func_77952_i());
                        int currentEssence = soulNetwork.getCurrentEssence();
                        int level = currentEssence * 15 / maxEssence;
                        return Math.min(15, level) % 16;
                    }
                }
            } else {
                int maxEssence = altar.getCapacity();
                int currentEssence = altar.getCurrentBlood();
                int level = currentEssence * 15 / maxEssence;
                return Math.min(15, level) % 16;
            }
        }
        return 0;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileAltar altar = (TileAltar)world.func_175625_s(pos);
        if (altar == null || player.func_70093_af()) {
            return false;
        }
        ItemStack playerItem = player.field_71071_by.func_70448_g();
        if (playerItem.func_77973_b() instanceof IAltarReader || playerItem.func_77973_b() instanceof IAltarManipulator) {
            playerItem.func_77973_b().func_77659_a(world, player, hand);
            return true;
        }
        if (Utils.insertItemToTile(altar, player)) {
            altar.startCycle();
        } else {
            altar.setActive();
        }
        world.func_184138_a(pos, state, state, 3);
        return true;
    }

    public void func_180663_b(World world, BlockPos blockPos, IBlockState blockState) {
        TileAltar tileAltar;
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile instanceof TileAltar && (tileAltar = (TileAltar)world.func_175625_s(blockPos)) != null) {
            tileAltar.dropItems();
        }
        super.func_180663_b(world, blockPos, blockState);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAltar();
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)0, (Object)"normal"));
        return ret;
    }

    @Override
    public List<ITextComponent> getDocumentation(EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        ArrayList<ITextComponent> docs = new ArrayList<ITextComponent>();
        IBloodAltar altar = (IBloodAltar)world.func_175625_s(pos);
        Pair<BlockPos, EnumAltarComponent> missingBlock = BloodAltar.getAltarMissingBlock(world, pos, altar.getTier().toInt());
        if (missingBlock != null) {
            docs.add((ITextComponent)new TextComponentTranslation("chat.bloodmagic.altar.nextTier", new Object[]{new TextComponentTranslation(((EnumAltarComponent)((Object)missingBlock.getRight())).getKey(), new Object[0]), Utils.prettifyBlockPosString((BlockPos)missingBlock.getLeft())}));
        }
        return docs;
    }
}

