/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.tile.TileAlchemyArray;
import WayofTime.bloodmagic.util.Utils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAlchemyArray
extends Block {
    protected static final AxisAlignedBB ARRAY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1, 1.0);

    public BlockAlchemyArray() {
        super(Material.field_151580_n);
        this.func_149663_c("bloodmagic.alchemyArray");
        this.func_149711_c(0.1f);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAlchemyArray) {
            ((TileAlchemyArray)tile).onEntityCollidedWithBlock(state, entity);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ARRAY_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileAlchemyArray array = (TileAlchemyArray)world.func_175625_s(pos);
        if (array == null || player.func_70093_af()) {
            return false;
        }
        ItemStack playerItem = player.func_184586_b(hand);
        if (!playerItem.func_190926_b()) {
            if (array.func_70301_a(0).func_190926_b()) {
                Utils.insertItemToTile(array, player, 0);
            } else if (!array.func_70301_a(0).func_190926_b()) {
                Utils.insertItemToTile(array, player, 1);
                array.attemptCraft();
            } else {
                return true;
            }
        }
        world.func_184138_a(pos, state, state, 3);
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModItems.ARCANE_ASHES);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180663_b(World world, BlockPos blockPos, IBlockState blockState) {
        TileAlchemyArray alchemyArray = (TileAlchemyArray)world.func_175625_s(blockPos);
        if (alchemyArray != null) {
            alchemyArray.dropItems();
        }
        super.func_180663_b(world, blockPos, blockState);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAlchemyArray();
    }
}

