/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.util.helper;

import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerHelper {
    private static final ArrayList<String> knownFakePlayers = Lists.newArrayList();

    public static String getUsernameFromPlayer(EntityPlayer player) {
        return player.func_130014_f_().field_72995_K ? "" : UsernameCache.getLastKnownUsername((UUID)PlayerHelper.getUUIDFromPlayer(player));
    }

    public static EntityPlayer getPlayerFromUsername(String username) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return null;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(username);
    }

    public static EntityPlayer getPlayerFromUUID(String uuid) {
        return PlayerHelper.getPlayerFromUsername(PlayerHelper.getUsernameFromUUID(uuid));
    }

    public static EntityPlayer getPlayerFromUUID(UUID uuid) {
        return PlayerHelper.getPlayerFromUsername(PlayerHelper.getUsernameFromUUID(uuid));
    }

    public static UUID getUUIDFromPlayer(EntityPlayer player) {
        return player.func_146103_bH().getId();
    }

    public static String getUsernameFromUUID(String uuid) {
        return UsernameCache.getLastKnownUsername((UUID)UUID.fromString(uuid));
    }

    public static String getUsernameFromUUID(UUID uuid) {
        return UsernameCache.getLastKnownUsername((UUID)uuid);
    }

    public static String getUsernameFromStack(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return stack.func_77978_p().func_74779_i("ownerNAME");
    }

    public static boolean isFakePlayer(EntityPlayer player) {
        return player instanceof FakePlayer || player != null && knownFakePlayers.contains(player.getClass().getCanonicalName());
    }

    public static void causeNauseaToPlayer(ItemStack stack) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        if (!Strings.isNullOrEmpty((String)(stack = NBTHelper.checkNBT(stack)).func_77978_p().func_74779_i("ownerUUID"))) {
            PlayerHelper.causeNauseaToPlayer(stack.func_77978_p().func_74779_i("ownerUUID"));
        }
    }

    public static void causeNauseaToPlayer(String ownerName) {
        EntityPlayer player = PlayerHelper.getPlayerFromUsername(ownerName);
        if (player == null) {
            return;
        }
        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 80));
    }
}

