/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.soul;

import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDemonWill;
import WayofTime.bloodmagic.api.soul.IDemonWillGem;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class PlayerDemonWillHandler {
    public static double getTotalDemonWill(EnumDemonWillType type, EntityPlayer player) {
        NonNullList inventory = player.field_71071_by.field_70462_a;
        double souls = 0.0;
        for (ItemStack stack : inventory) {
            if (stack.func_77973_b() instanceof IDemonWill && ((IDemonWill)stack.func_77973_b()).getType(stack) == type) {
                souls += ((IDemonWill)stack.func_77973_b()).getWill(type, stack);
                continue;
            }
            if (!(stack.func_77973_b() instanceof IDemonWillGem)) continue;
            souls += ((IDemonWillGem)stack.func_77973_b()).getWill(type, stack);
        }
        return souls;
    }

    public static EnumDemonWillType getLargestWillType(EntityPlayer player) {
        EnumDemonWillType type = EnumDemonWillType.DEFAULT;
        double max = PlayerDemonWillHandler.getTotalDemonWill(type, player);
        for (EnumDemonWillType testType : EnumDemonWillType.values()) {
            double value = PlayerDemonWillHandler.getTotalDemonWill(testType, player);
            if (!(value > max)) continue;
            type = testType;
        }
        return type;
    }

    public static boolean isDemonWillFull(EnumDemonWillType type, EntityPlayer player) {
        NonNullList inventory = player.field_71071_by.field_70462_a;
        boolean hasGem = false;
        for (ItemStack stack : inventory) {
            if (!(stack.func_77973_b() instanceof IDemonWillGem)) continue;
            hasGem = true;
            if (!(((IDemonWillGem)stack.func_77973_b()).getWill(type, stack) < (double)((IDemonWillGem)stack.func_77973_b()).getMaxWill(type, stack))) continue;
            return false;
        }
        return hasGem;
    }

    public static double consumeDemonWill(EnumDemonWillType type, EntityPlayer player, double amount) {
        double consumed = 0.0;
        NonNullList inventory = player.field_71071_by.field_70462_a;
        for (int i = 0; i < inventory.size(); ++i) {
            if (consumed >= amount) {
                return consumed;
            }
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.func_77973_b() instanceof IDemonWill && ((IDemonWill)stack.func_77973_b()).getType(stack) == type) {
                consumed += ((IDemonWill)stack.func_77973_b()).drainWill(type, stack, amount - consumed);
                if (!(((IDemonWill)stack.func_77973_b()).getWill(type, stack) <= 0.0)) continue;
                inventory.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            if (!(stack.func_77973_b() instanceof IDemonWillGem)) continue;
            consumed += ((IDemonWillGem)stack.func_77973_b()).drainWill(type, stack, amount - consumed, true);
        }
        return consumed;
    }

    public static ItemStack addDemonWill(EntityPlayer player, ItemStack willStack) {
        if (willStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        NonNullList inventory = player.field_71071_by.field_70462_a;
        for (ItemStack stack : inventory) {
            ItemStack newStack;
            if (!(stack.func_77973_b() instanceof IDemonWillGem) || !(newStack = ((IDemonWillGem)stack.func_77973_b()).fillDemonWillGem(stack, willStack)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return willStack;
    }

    public static double addDemonWill(EnumDemonWillType type, EntityPlayer player, double amount) {
        ItemStack stack;
        NonNullList inventory = player.field_71071_by.field_70462_a;
        double remaining = amount;
        Iterator iterator = inventory.iterator();
        while (!(!iterator.hasNext() || (stack = (ItemStack)iterator.next()).func_77973_b() instanceof IDemonWillGem && (remaining -= ((IDemonWillGem)stack.func_77973_b()).fillWill(type, stack, remaining, true)) <= 0.0)) {
        }
        return amount - remaining;
    }

    public static double addDemonWill(EnumDemonWillType type, EntityPlayer player, double amount, ItemStack ignored) {
        ItemStack stack;
        NonNullList inventory = player.field_71071_by.field_70462_a;
        double remaining = amount;
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext() && ((stack = (ItemStack)iterator.next()).equals(ignored) || !(stack.func_77973_b() instanceof IDemonWillGem) || !((remaining -= ((IDemonWillGem)stack.func_77973_b()).fillWill(type, stack, remaining, true)) <= 0.0))) {
        }
        return amount - remaining;
    }
}

