/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.registry;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.ritual.Ritual;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RitualRegistry {
    public static final Map<Ritual, Boolean> enabledRituals = new HashMap<Ritual, Boolean>();
    private static final BiMap<String, Ritual> registry = HashBiMap.create();
    private static final List<String> lookupList = new ArrayList<String>();
    private static final ArrayList<String> orderedIdList = new ArrayList();
    private static boolean locked;

    public static void registerRitual(Ritual ritual, String id, boolean enabled) {
        if (locked) {
            BloodMagicAPI.getLogger().error("This registry has been locked. Please register your ritual earlier.", new Object[0]);
            BloodMagicAPI.getLogger().error("If you reflect this, I will hunt you down. - TehNut", new Object[0]);
            return;
        }
        if (ritual != null) {
            if (registry.containsKey((Object)id)) {
                BloodMagicAPI.getLogger().error("Duplicate ritual id: %s", id);
            } else {
                registry.put((Object)id, (Object)ritual);
                enabledRituals.put(ritual, enabled);
                orderedIdList.add(id);
            }
        }
    }

    public static void registerRitual(Ritual ritual, boolean enabled) {
        RitualRegistry.registerRitual(ritual, ritual.getName(), enabled);
    }

    public static void registerRitual(Ritual ritual, String id) {
        RitualRegistry.registerRitual(ritual, id, true);
    }

    public static void registerRitual(Ritual ritual) {
        RitualRegistry.registerRitual(ritual, ritual.getName());
    }

    @Nullable
    public static Ritual getRitualForId(String id) {
        Ritual ritual = (Ritual)registry.get((Object)id);
        return ritual != null ? ritual.getNewCopy() : null;
    }

    public static String getIdForRitual(Ritual ritual) {
        return (String)registry.inverse().get((Object)ritual);
    }

    public static boolean isMapEmpty() {
        return registry.isEmpty();
    }

    public static int getMapSize() {
        return registry.size();
    }

    public static boolean ritualEnabled(Ritual ritual) {
        try {
            return enabledRituals.get(ritual);
        }
        catch (NullPointerException e) {
            BloodMagicAPI.getLogger().error("Invalid Ritual was called", new Object[0]);
            return false;
        }
    }

    public static boolean ritualEnabled(String id) {
        return RitualRegistry.ritualEnabled(RitualRegistry.getRitualForId(id));
    }

    public static BiMap<String, Ritual> getRegistry() {
        return HashBiMap.create(registry);
    }

    public static Map<Ritual, Boolean> getEnabledMap() {
        return new HashMap<Ritual, Boolean>(enabledRituals);
    }

    public static ArrayList<String> getIds() {
        return new ArrayList<String>(lookupList);
    }

    public static ArrayList<String> getOrderedIds() {
        return orderedIdList;
    }

    public static ArrayList<Ritual> getRituals() {
        return new ArrayList<Ritual>(registry.values());
    }

    public static void orderLookupList() {
        locked = true;
        lookupList.clear();
        lookupList.addAll(registry.keySet());
        Collections.sort(lookupList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Ritual ritual1 = (Ritual)registry.get((Object)o1);
                Ritual ritual2 = (Ritual)registry.get((Object)o2);
                return ritual1.getComponents().size() > ritual2.getComponents().size() ? -1 : 0;
            }
        });
    }
}

