/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.registry;

import WayofTime.bloodmagic.api.ItemStackWrapper;
import WayofTime.bloodmagic.api.alchemyCrafting.AlchemyArrayEffect;
import WayofTime.bloodmagic.api.alchemyCrafting.AlchemyArrayEffectCrafting;
import WayofTime.bloodmagic.api.alchemyCrafting.AlchemyCircleRenderer;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class AlchemyArrayRecipeRegistry {
    public static final AlchemyCircleRenderer defaultRenderer = new AlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/BaseArray.png"));
    private static BiMap<List<ItemStack>, AlchemyArrayRecipe> recipes = HashBiMap.create();
    private static HashMap<String, AlchemyArrayEffect> effectMap = new HashMap();

    public static void registerRecipe(List<ItemStack> input, @Nullable ItemStack catalystStack, AlchemyArrayEffect arrayEffect, AlchemyCircleRenderer circleRenderer) {
        effectMap.put(arrayEffect.getKey(), arrayEffect);
        for (Map.Entry entry : recipes.entrySet()) {
            AlchemyArrayRecipe arrayRecipe = (AlchemyArrayRecipe)entry.getValue();
            if (!arrayRecipe.doesInputMatchRecipe(input)) continue;
            AlchemyArrayEffect eff = arrayRecipe.getAlchemyArrayEffectForCatalyst(catalystStack);
            if (eff != null) {
                return;
            }
            arrayRecipe.catalystMap.put((Object)ItemStackWrapper.getHolder(catalystStack), (Object)arrayEffect);
            if (circleRenderer != null) {
                if (arrayRecipe.defaultCircleRenderer == null) {
                    arrayRecipe.defaultCircleRenderer = circleRenderer;
                } else {
                    arrayRecipe.circleMap.put((Object)ItemStackWrapper.getHolder(catalystStack), (Object)circleRenderer);
                }
            }
            return;
        }
        recipes.put(input, (Object)new AlchemyArrayRecipe(input, catalystStack, arrayEffect, circleRenderer == null ? defaultRenderer : circleRenderer));
    }

    public static AlchemyArrayEffect getAlchemyArrayEffect(String key) {
        return effectMap.get(key);
    }

    public static ItemStack[] getRecipeForArrayEffect(String key) {
        for (Map.Entry entry : recipes.entrySet()) {
            AlchemyArrayRecipe recipe = (AlchemyArrayRecipe)entry.getValue();
            if (recipe == null || ((List)entry.getKey()).size() <= 0) continue;
            for (Map.Entry effectEntry : recipe.catalystMap.entrySet()) {
                if (effectEntry.getValue() == null || !((AlchemyArrayEffect)effectEntry.getValue()).key.equals(key)) continue;
                return new ItemStack[]{(ItemStack)((List)entry.getKey()).get(0), ((ItemStackWrapper)effectEntry.getKey()).toStack()};
            }
        }
        return new ItemStack[]{null, null};
    }

    public static ItemStack[] getRecipeForOutputStack(ItemStack stack) {
        for (Map.Entry entry : recipes.entrySet()) {
            AlchemyArrayRecipe recipe = (AlchemyArrayRecipe)entry.getValue();
            if (recipe == null || ((List)entry.getKey()).size() <= 0) continue;
            for (Map.Entry effectEntry : recipe.catalystMap.entrySet()) {
                AlchemyArrayEffectCrafting craftingEffect;
                ItemStack resultStack;
                if (!(effectEntry.getValue() instanceof AlchemyArrayEffectCrafting) || (resultStack = (craftingEffect = (AlchemyArrayEffectCrafting)effectEntry.getValue()).getOutputStack()) == null || resultStack.func_77973_b() == null || resultStack.func_77973_b() != stack.func_77973_b() || resultStack.func_77952_i() != stack.func_77952_i()) continue;
                return new ItemStack[]{(ItemStack)((List)entry.getKey()).get(0), ((ItemStackWrapper)effectEntry.getKey()).toStack()};
            }
        }
        return new ItemStack[]{null, null};
    }

    public static void registerCraftingRecipe(ItemStack input, ItemStack catalystStack, ItemStack outputStack, ResourceLocation arrayResource) {
        AlchemyArrayRecipeRegistry.registerRecipe(input, catalystStack, (AlchemyArrayEffect)new AlchemyArrayEffectCrafting(outputStack), arrayResource);
    }

    public static void registerCraftingRecipe(List<ItemStack> inputStacks, ItemStack catalystStack, ItemStack outputStack, ResourceLocation arrayResource) {
        AlchemyArrayRecipeRegistry.registerRecipe(inputStacks, catalystStack, (AlchemyArrayEffect)new AlchemyArrayEffectCrafting(outputStack), arrayResource);
    }

    public static void registerCraftingRecipe(String inputOreDict, ItemStack catalystStack, ItemStack outputStack, ResourceLocation arrayResource) {
        AlchemyArrayRecipeRegistry.registerRecipe((List<ItemStack>)(OreDictionary.doesOreNameExist((String)inputOreDict) && OreDictionary.getOres((String)inputOreDict).size() > 0 ? OreDictionary.getOres((String)inputOreDict) : Collections.emptyList()), catalystStack, (AlchemyArrayEffect)new AlchemyArrayEffectCrafting(outputStack), arrayResource);
    }

    public static void registerCraftingRecipe(ItemStack input, ItemStack catalystStack, ItemStack outputStack) {
        AlchemyArrayRecipeRegistry.registerRecipe(input, catalystStack, (AlchemyArrayEffect)new AlchemyArrayEffectCrafting(outputStack));
    }

    public static void registerCraftingRecipe(List<ItemStack> inputStacks, ItemStack catalystStack, ItemStack outputStack) {
        AlchemyArrayRecipeRegistry.registerRecipe(inputStacks, catalystStack, (AlchemyArrayEffect)new AlchemyArrayEffectCrafting(outputStack));
    }

    public static void registerCraftingRecipe(String inputOreDict, ItemStack catalystStack, ItemStack outputStack) {
        AlchemyArrayRecipeRegistry.registerRecipe((List<ItemStack>)(OreDictionary.doesOreNameExist((String)inputOreDict) && OreDictionary.getOres((String)inputOreDict).size() > 0 ? OreDictionary.getOres((String)inputOreDict) : Collections.emptyList()), catalystStack, (AlchemyArrayEffect)new AlchemyArrayEffectCrafting(outputStack));
    }

    public static void registerRecipe(ItemStack inputStacks, ItemStack catalystStack, AlchemyArrayEffect arrayEffect, ResourceLocation arrayResource) {
        AlchemyCircleRenderer circleRenderer = arrayResource == null ? defaultRenderer : new AlchemyCircleRenderer(arrayResource);
        AlchemyArrayRecipeRegistry.registerRecipe(Collections.singletonList(inputStacks), catalystStack, arrayEffect, circleRenderer);
    }

    public static void registerRecipe(ItemStack inputStacks, ItemStack catalystStack, AlchemyArrayEffect arrayEffect, AlchemyCircleRenderer circleRenderer) {
        AlchemyArrayRecipeRegistry.registerRecipe(Collections.singletonList(inputStacks), catalystStack, arrayEffect, circleRenderer);
    }

    public static void registerRecipe(List<ItemStack> inputStacks, ItemStack catalystStack, AlchemyArrayEffect arrayEffect, ResourceLocation arrayResource) {
        AlchemyCircleRenderer circleRenderer = arrayResource == null ? defaultRenderer : new AlchemyCircleRenderer(arrayResource);
        AlchemyArrayRecipeRegistry.registerRecipe(inputStacks, catalystStack, arrayEffect, circleRenderer);
    }

    public static void registerRecipe(String inputOreDict, ItemStack catalystStack, AlchemyArrayEffect arrayEffect, ResourceLocation arrayResource) {
        AlchemyCircleRenderer circleRenderer = arrayResource == null ? defaultRenderer : new AlchemyCircleRenderer(arrayResource);
        AlchemyArrayRecipeRegistry.registerRecipe(OreDictionary.doesOreNameExist((String)inputOreDict) && OreDictionary.getOres((String)inputOreDict).size() > 0 ? OreDictionary.getOres((String)inputOreDict) : Collections.emptyList(), catalystStack, arrayEffect, circleRenderer);
    }

    public static void registerRecipe(ItemStack input, ItemStack catalystStack, AlchemyArrayEffect arrayEffect) {
        AlchemyArrayRecipeRegistry.registerRecipe(Collections.singletonList(input), catalystStack, arrayEffect, (AlchemyCircleRenderer)null);
    }

    public static void registerRecipe(List<ItemStack> inputStacks, ItemStack catalystStack, AlchemyArrayEffect arrayEffect) {
        AlchemyArrayRecipeRegistry.registerRecipe(inputStacks, catalystStack, arrayEffect, (AlchemyCircleRenderer)null);
    }

    public static void registerRecipe(String inputOreDict, ItemStack catalystStack, AlchemyArrayEffect arrayEffect) {
        AlchemyArrayRecipeRegistry.registerRecipe((List<ItemStack>)(OreDictionary.doesOreNameExist((String)inputOreDict) && OreDictionary.getOres((String)inputOreDict).size() > 0 ? OreDictionary.getOres((String)inputOreDict) : Collections.emptyList()), catalystStack, arrayEffect, (AlchemyCircleRenderer)null);
    }

    public static void replaceAlchemyCircle(List<ItemStack> input, AlchemyCircleRenderer circleRenderer) {
        if (circleRenderer == null) {
            return;
        }
        for (Map.Entry entry : recipes.entrySet()) {
            AlchemyArrayRecipe arrayRecipe = (AlchemyArrayRecipe)entry.getValue();
            if (!arrayRecipe.doesInputMatchRecipe(input)) continue;
            arrayRecipe.defaultCircleRenderer = circleRenderer;
        }
    }

    public static AlchemyArrayRecipe getRecipeForInput(List<ItemStack> input) {
        return (AlchemyArrayRecipe)recipes.get(input);
    }

    public static AlchemyArrayEffect getAlchemyArrayEffect(List<ItemStack> input, @Nullable ItemStack catalystStack) {
        for (Map.Entry entry : recipes.entrySet()) {
            AlchemyArrayRecipe arrayRecipe = (AlchemyArrayRecipe)entry.getValue();
            if (input.size() == 1 && arrayRecipe.getInput().size() == 1) {
                if (!ItemStackWrapper.getHolder(arrayRecipe.getInput().get(0)).equals(ItemStackWrapper.getHolder(input.get(0)))) continue;
                AlchemyArrayEffect effect = arrayRecipe.getAlchemyArrayEffectForCatalyst(catalystStack);
                if (effect != null) {
                    return effect.getNewCopy();
                }
                return null;
            }
            if (!input.equals(arrayRecipe.getInput())) continue;
            AlchemyArrayEffect effect = arrayRecipe.getAlchemyArrayEffectForCatalyst(catalystStack);
            if (effect != null) {
                return effect.getNewCopy();
            }
            return null;
        }
        return null;
    }

    public static AlchemyArrayEffect getAlchemyArrayEffect(ItemStack input, @Nullable ItemStack catalystStack) {
        return AlchemyArrayRecipeRegistry.getAlchemyArrayEffect(Collections.singletonList(input), catalystStack);
    }

    public static AlchemyCircleRenderer getAlchemyCircleRenderer(List<ItemStack> input, @Nullable ItemStack catalystStack) {
        for (Map.Entry entry : recipes.entrySet()) {
            AlchemyArrayRecipe arrayRecipe = (AlchemyArrayRecipe)entry.getValue();
            if (!arrayRecipe.doesInputMatchRecipe(input)) continue;
            return arrayRecipe.getAlchemyArrayRendererForCatalyst(catalystStack);
        }
        return defaultRenderer;
    }

    public static AlchemyCircleRenderer getAlchemyCircleRenderer(ItemStack itemStack, @Nullable ItemStack catalystStack) {
        return AlchemyArrayRecipeRegistry.getAlchemyCircleRenderer(Collections.singletonList(itemStack), catalystStack);
    }

    public static BiMap<List<ItemStack>, AlchemyArrayRecipe> getRecipes() {
        return HashBiMap.create(recipes);
    }

    public static class AlchemyArrayRecipe {
        public AlchemyCircleRenderer defaultCircleRenderer;
        public final List<ItemStack> input;
        public final BiMap<ItemStackWrapper, AlchemyArrayEffect> catalystMap = HashBiMap.create();
        public final BiMap<ItemStackWrapper, AlchemyCircleRenderer> circleMap = HashBiMap.create();

        private AlchemyArrayRecipe(List<ItemStack> input, ItemStack catalystStack, AlchemyArrayEffect arrayEffect, AlchemyCircleRenderer circleRenderer, boolean useless) {
            this.input = input;
            this.catalystMap.put((Object)ItemStackWrapper.getHolder(catalystStack), (Object)arrayEffect);
            this.defaultCircleRenderer = circleRenderer;
        }

        public AlchemyArrayRecipe(ItemStack inputStack, ItemStack catalystStack, AlchemyArrayEffect arrayEffect, AlchemyCircleRenderer circleRenderer) {
            this(Collections.singletonList(inputStack), catalystStack, arrayEffect, circleRenderer, false);
        }

        public AlchemyArrayRecipe(String inputOreDict, ItemStack catalystStack, AlchemyArrayEffect arrayEffect, AlchemyCircleRenderer circleRenderer) {
            this((List<ItemStack>)(OreDictionary.doesOreNameExist((String)inputOreDict) && OreDictionary.getOres((String)inputOreDict).size() > 0 ? OreDictionary.getOres((String)inputOreDict) : Collections.emptyList()), catalystStack, arrayEffect, circleRenderer, false);
        }

        public AlchemyArrayRecipe(List<ItemStack> inputStacks, ItemStack catalystStack, AlchemyArrayEffect arrayEffect, AlchemyCircleRenderer circleRenderer) {
            this(inputStacks, catalystStack, arrayEffect, circleRenderer, false);
        }

        public boolean doesInputMatchRecipe(List<ItemStack> comparedList) {
            return comparedList != null && this.input != null && (this.input.size() == 1 && comparedList.size() == 1 ? this.input.get(0).func_77969_a(comparedList.get(0)) : this.input.equals(comparedList));
        }

        public AlchemyArrayEffect getAlchemyArrayEffectForCatalyst(@Nullable ItemStack comparedStack) {
            for (Map.Entry entry : this.catalystMap.entrySet()) {
                ItemStack catalystStack = ((ItemStackWrapper)entry.getKey()).toStack();
                if (comparedStack == null && catalystStack == null) {
                    return (AlchemyArrayEffect)entry.getValue();
                }
                if (comparedStack == null || catalystStack == null || !catalystStack.func_77969_a(comparedStack)) continue;
                return (AlchemyArrayEffect)entry.getValue();
            }
            return null;
        }

        public AlchemyCircleRenderer getAlchemyArrayRendererForCatalyst(@Nullable ItemStack comparedStack) {
            for (Map.Entry entry : this.circleMap.entrySet()) {
                ItemStack catalystStack = ((ItemStackWrapper)entry.getKey()).toStack();
                if (comparedStack == null && catalystStack == null) {
                    return (AlchemyCircleRenderer)entry.getValue();
                }
                if (comparedStack == null || catalystStack == null || !catalystStack.func_77969_a(comparedStack)) continue;
                return (AlchemyCircleRenderer)entry.getValue();
            }
            return this.defaultCircleRenderer;
        }

        public AlchemyCircleRenderer getDefaultCircleRenderer() {
            return this.defaultCircleRenderer;
        }

        public List<ItemStack> getInput() {
            return this.input;
        }

        public BiMap<ItemStackWrapper, AlchemyArrayEffect> getCatalystMap() {
            return this.catalystMap;
        }

        public BiMap<ItemStackWrapper, AlchemyCircleRenderer> getCircleMap() {
            return this.circleMap;
        }

        public String toString() {
            return "AlchemyArrayRecipeRegistry.AlchemyArrayRecipe(defaultCircleRenderer=" + this.getDefaultCircleRenderer() + ", input=" + this.getInput() + ", catalystMap=" + this.getCatalystMap() + ", circleMap=" + this.getCircleMap() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlchemyArrayRecipe)) {
                return false;
            }
            AlchemyArrayRecipe other = (AlchemyArrayRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AlchemyCircleRenderer this$defaultCircleRenderer = this.getDefaultCircleRenderer();
            AlchemyCircleRenderer other$defaultCircleRenderer = other.getDefaultCircleRenderer();
            if (this$defaultCircleRenderer == null ? other$defaultCircleRenderer != null : !this$defaultCircleRenderer.equals(other$defaultCircleRenderer)) {
                return false;
            }
            List<ItemStack> this$input = this.getInput();
            List<ItemStack> other$input = other.getInput();
            if (this$input == null ? other$input != null : !((Object)this$input).equals(other$input)) {
                return false;
            }
            BiMap<ItemStackWrapper, AlchemyArrayEffect> this$catalystMap = this.getCatalystMap();
            BiMap<ItemStackWrapper, AlchemyArrayEffect> other$catalystMap = other.getCatalystMap();
            if (this$catalystMap == null ? other$catalystMap != null : !this$catalystMap.equals(other$catalystMap)) {
                return false;
            }
            BiMap<ItemStackWrapper, AlchemyCircleRenderer> this$circleMap = this.getCircleMap();
            BiMap<ItemStackWrapper, AlchemyCircleRenderer> other$circleMap = other.getCircleMap();
            return !(this$circleMap == null ? other$circleMap != null : !this$circleMap.equals(other$circleMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AlchemyArrayRecipe;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AlchemyCircleRenderer $defaultCircleRenderer = this.getDefaultCircleRenderer();
            result = result * 59 + ($defaultCircleRenderer == null ? 43 : $defaultCircleRenderer.hashCode());
            List<ItemStack> $input = this.getInput();
            result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
            BiMap<ItemStackWrapper, AlchemyArrayEffect> $catalystMap = this.getCatalystMap();
            result = result * 59 + ($catalystMap == null ? 43 : $catalystMap.hashCode());
            BiMap<ItemStackWrapper, AlchemyCircleRenderer> $circleMap = this.getCircleMap();
            result = result * 59 + ($circleMap == null ? 43 : $circleMap.hashCode());
            return result;
        }
    }
}

