/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class TartaricForgeRecipe {
    protected ItemStack output = null;
    protected List<Object> input = new ArrayList<Object>();
    protected double minimumSouls;
    protected double soulsDrained;

    public TartaricForgeRecipe(Block result, double minSouls, double drain, Object ... recipe) {
        this(new ItemStack(result), minSouls, drain, recipe);
    }

    public TartaricForgeRecipe(Item result, double minSouls, double drain, Object ... recipe) {
        this(new ItemStack(result), minSouls, drain, recipe);
    }

    public TartaricForgeRecipe(ItemStack result, double minSouls, double drain, Object ... recipe) {
        this.output = result.func_77946_l();
        this.minimumSouls = minSouls;
        this.soulsDrained = drain;
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid soul forge recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public ItemStack getRecipeOutput() {
        return this.output.func_77946_l();
    }

    public boolean matches(List<ItemStack> checkedList, World world, BlockPos pos) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (int x = 0; x < checkedList.size(); ++x) {
            ItemStack slot = checkedList.get(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<Object> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public List<Object> getInput() {
        return this.input;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TartaricForgeRecipe)) {
            return false;
        }
        TartaricForgeRecipe other = (TartaricForgeRecipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ItemStack this$output = this.output;
        ItemStack other$output = other.output;
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        List<Object> this$input = this.getInput();
        List<Object> other$input = other.getInput();
        if (this$input == null ? other$input != null : !((Object)this$input).equals(other$input)) {
            return false;
        }
        if (Double.compare(this.getMinimumSouls(), other.getMinimumSouls()) != 0) {
            return false;
        }
        return Double.compare(this.getSoulsDrained(), other.getSoulsDrained()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof TartaricForgeRecipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ItemStack $output = this.output;
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        List<Object> $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
        long $minimumSouls = Double.doubleToLongBits(this.getMinimumSouls());
        result = result * 59 + (int)($minimumSouls >>> 32 ^ $minimumSouls);
        long $soulsDrained = Double.doubleToLongBits(this.getSoulsDrained());
        result = result * 59 + (int)($soulsDrained >>> 32 ^ $soulsDrained);
        return result;
    }

    public String toString() {
        return "TartaricForgeRecipe(output=" + this.output + ", input=" + this.getInput() + ", minimumSouls=" + this.getMinimumSouls() + ", soulsDrained=" + this.getSoulsDrained() + ")";
    }

    public double getMinimumSouls() {
        return this.minimumSouls;
    }

    public double getSoulsDrained() {
        return this.soulsDrained;
    }
}

