/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.impl;

import WayofTime.bloodmagic.api.iface.IActivatable;
import WayofTime.bloodmagic.api.iface.ISigil;
import WayofTime.bloodmagic.api.impl.ItemSigil;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import com.google.common.base.Strings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemSigilToggleable
extends ItemSigil
implements IActivatable {
    public ItemSigilToggleable(int lpUsed) {
        super(lpUsed);
    }

    @Override
    public boolean getActivated(ItemStack stack) {
        return !stack.func_190926_b() && NBTHelper.checkNBT(stack).func_77978_p().func_74767_n("activated");
    }

    @Override
    public ItemStack setActivatedState(ItemStack stack, boolean activated) {
        if (!stack.func_190926_b()) {
            NBTHelper.checkNBT(stack).func_77978_p().func_74757_a("activated", activated);
            return stack;
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K && !this.isUnusable(stack)) {
            if (player.func_70093_af()) {
                this.setActivatedState(stack, !this.getActivated(stack));
            }
            if (this.getActivated(stack) && NetworkHelper.getSoulNetwork(player).syphonAndDamage(player, this.getLpUsed())) {
                return super.func_77659_a(world, player, hand);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (Strings.isNullOrEmpty((String)this.getOwnerUUID(stack)) || player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        return NetworkHelper.getSoulNetwork(this.getOwnerUUID(player.func_184586_b(hand))).syphonAndDamage(player, this.getLpUsed()) && this.onSigilUse(player.func_184586_b(hand), player, world, pos, side, hitX, hitY, hitZ) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public boolean onSigilUse(ItemStack itemStack, EntityPlayer player, World world, BlockPos blockPos, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayerMP && this.getActivated(stack)) {
            if (entityIn.field_70173_aa % 100 == 0 && !NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage((EntityPlayer)entityIn, this.getLpUsed())) {
                this.setActivatedState(stack, false);
            }
            this.onSigilUpdate(stack, worldIn, (EntityPlayer)entityIn, itemSlot, isSelected);
        }
    }

    public void onSigilUpdate(ItemStack stack, World world, EntityPlayer player, int itemSlot, boolean isSelected) {
    }
}

