/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.event;

import WayofTime.bloodmagic.api.BlockStack;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Cancelable
public class TeleposeEvent
extends Event {
    public final World initalWorld;
    public final BlockPos initialBlockPos;
    public final BlockStack initialStack;
    public final World finalWorld;
    public final BlockPos finalBlockPos;
    public final BlockStack finalStack;

    public TeleposeEvent(World initialWorld, BlockPos initialBlockPos, World finalWorld, BlockPos finalBlockPos) {
        this.initalWorld = initialWorld;
        this.initialBlockPos = initialBlockPos;
        this.initialStack = BlockStack.getStackFromPos(initialWorld, initialBlockPos);
        this.finalWorld = finalWorld;
        this.finalBlockPos = finalBlockPos;
        this.finalStack = BlockStack.getStackFromPos(finalWorld, finalBlockPos);
    }

    public TileEntity getInitialTile() {
        return this.initalWorld.func_175625_s(this.initialBlockPos);
    }

    public TileEntity getFinalTile() {
        return this.finalWorld.func_175625_s(this.finalBlockPos);
    }

    @Cancelable
    public static class Ent
    extends TeleposeEvent {
        public final Entity entity;

        public Ent(Entity entity, World initialWorld, BlockPos initialBlockPos, World finalWorld, BlockPos finalBlockPos) {
            super(initialWorld, initialBlockPos, finalWorld, finalBlockPos);
            this.entity = entity;
        }

        @Override
        public TileEntity getInitialTile() throws IllegalArgumentException {
            throw new IllegalArgumentException("Attempted to get a TileEntity from an Entity Telepose Event.");
        }

        @Override
        public TileEntity getFinalTile() throws IllegalArgumentException {
            throw new IllegalArgumentException("Attempted to get a TileEntity from an Entity Telepose Event.");
        }

        public static class Post
        extends Ent {
            public Post(Entity entity, World initialWorld, BlockPos initialBlockPos, World finalWorld, BlockPos finalBlockPos) {
                super(entity, initialWorld, initialBlockPos, finalWorld, finalBlockPos);
            }
        }
    }
}

