/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api;

import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.Constants;
import WayofTime.bloodmagic.api.DamageSourceBloodMagic;
import WayofTime.bloodmagic.api.altar.EnumAltarComponent;
import WayofTime.bloodmagic.api.util.helper.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BloodMagicAPI {
    private static final List<BlockStack> teleposerBlacklist = new ArrayList<BlockStack>();
    private static final List<BlockStack> transpositionBlacklist = new ArrayList<BlockStack>();
    private static final Map<String, Integer> entitySacrificeValues = new HashMap<String, Integer>();
    private static final ArrayList<Block> greenGroveBlacklist = new ArrayList();
    private static final Map<IBlockState, EnumAltarComponent> altarComponents = new HashMap<IBlockState, EnumAltarComponent>();
    private static boolean loggingEnabled;
    private static LogHelper logger;
    private static DamageSource damageSource;
    private static Fluid lifeEssence;
    private static ItemStack lifeEssenceBucket;

    public static ItemStack getLifeEssenceBucket() {
        if (lifeEssenceBucket != null) {
            return lifeEssenceBucket;
        }
        lifeEssenceBucket = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)BloodMagicAPI.getLifeEssence());
        return lifeEssenceBucket;
    }

    public static Item getItem(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("bloodmagic", name));
    }

    public static Item getItem(Constants.BloodMagicItem bloodMagicItem) {
        return BloodMagicAPI.getItem(bloodMagicItem.getRegName());
    }

    public static Block getBlock(String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("bloodmagic", name));
    }

    public static Block getBlock(Constants.BloodMagicBlock bloodMagicBlock) {
        return BloodMagicAPI.getBlock(bloodMagicBlock.getRegName());
    }

    public static void addToTeleposerBlacklist(BlockStack blockStack) {
        if (!teleposerBlacklist.contains(blockStack)) {
            teleposerBlacklist.add(blockStack);
        }
    }

    public static void addToTeleposerBlacklist(Block block, int meta) {
        BloodMagicAPI.addToTeleposerBlacklist(new BlockStack(block, meta));
    }

    public static void addToTeleposerBlacklist(Block block) {
        BloodMagicAPI.addToTeleposerBlacklist(block, 0);
    }

    public static void addToTranspositionBlacklist(BlockStack blockStack) {
        if (!transpositionBlacklist.contains(blockStack)) {
            transpositionBlacklist.add(blockStack);
        }
    }

    public static void addToTranspositionBlacklist(Block block, int meta) {
        BloodMagicAPI.addToTranspositionBlacklist(new BlockStack(block, meta));
    }

    public static void addToTranspositionBlacklist(Block block) {
        BloodMagicAPI.addToTranspositionBlacklist(block, 0);
    }

    public static void setEntitySacrificeValue(Class<? extends EntityLivingBase> entityClass, int sacrificeValue) {
        if (!entitySacrificeValues.containsKey(entityClass.getSimpleName())) {
            entitySacrificeValues.put(entityClass.getSimpleName(), sacrificeValue);
        }
    }

    public static void setEntitySacrificeValue(String entityClassName, int sacrificeValue) {
        if (!entitySacrificeValues.containsKey(entityClassName)) {
            entitySacrificeValues.put(entityClassName, sacrificeValue);
        }
    }

    public static void blacklistFromGreenGrove(Block block) {
        if (!greenGroveBlacklist.contains(block)) {
            greenGroveBlacklist.add(block);
        }
    }

    public static void addAltarComponent(IBlockState state, EnumAltarComponent altarComponent) {
        if (!altarComponents.containsKey(state)) {
            altarComponents.put(state, altarComponent);
        }
    }

    public static List<BlockStack> getTeleposerBlacklist() {
        return teleposerBlacklist;
    }

    public static List<BlockStack> getTranspositionBlacklist() {
        return transpositionBlacklist;
    }

    public static Map<String, Integer> getEntitySacrificeValues() {
        return entitySacrificeValues;
    }

    public static ArrayList<Block> getGreenGroveBlacklist() {
        return greenGroveBlacklist;
    }

    public static Map<IBlockState, EnumAltarComponent> getAltarComponents() {
        return altarComponents;
    }

    public static boolean isLoggingEnabled() {
        return loggingEnabled;
    }

    public static void setLoggingEnabled(boolean loggingEnabled) {
        BloodMagicAPI.loggingEnabled = loggingEnabled;
    }

    public static LogHelper getLogger() {
        return logger;
    }

    public static DamageSource getDamageSource() {
        return damageSource;
    }

    public static Fluid getLifeEssence() {
        return lifeEssence;
    }

    public static void setLifeEssence(Fluid lifeEssence) {
        BloodMagicAPI.lifeEssence = lifeEssence;
    }

    static {
        logger = new LogHelper("BloodMagic|API");
        damageSource = new DamageSourceBloodMagic();
    }
}

