/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier6;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.helpful.tier6.EntityWitherStormHead;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWitherStormSkull
extends EntityFireball {
    private static final DataParameter<Boolean> INVULNERABLE = EntityDataManager.func_187226_a(EntityWitherStormSkull.class, (DataSerializer)DataSerializers.field_187198_h);
    public float damage = 20.0f;

    public EntityWitherStormSkull(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.75f, 0.75f);
    }

    public EntityWitherStormSkull(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ) {
        super(worldIn, shooter, accelX, accelY, accelZ);
        this.func_70105_a(0.75f, 0.75f);
    }

    protected float func_82341_c() {
        return 0.9f;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityWitherStormSkull(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(worldIn, x, y, z, accelX, accelY, accelZ);
        this.func_70105_a(0.75f, 0.75f);
    }

    public boolean func_70027_ad() {
        return false;
    }

    public float func_180428_a(Explosion explosionIn, World worldIn, BlockPos pos, IBlockState blockStateIn) {
        float f = super.func_180428_a(explosionIn, worldIn, pos, blockStateIn);
        Block block = blockStateIn.func_177230_c();
        if (EntityWither.func_181033_a((Block)block)) {
            f = Math.min(0.8f, f);
        }
        return f;
    }

    protected void func_70227_a(RayTraceResult movingObject) {
        if (!this.field_70170_p.field_72995_K) {
            if (movingObject.field_72308_g != null) {
                if (this.field_70235_a != null && movingObject.field_72308_g instanceof EntityLivingBase && !this.field_70235_a.func_184191_r((Entity)((EntityLivingBase)movingObject.field_72308_g))) {
                    if (((EntityLivingBase)movingObject.field_72308_g).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                        if (movingObject.field_72308_g.func_70097_a(DamageSource.field_76376_m, this.damage * 3.0f)) {
                            if (!movingObject.field_72308_g.func_70089_S()) {
                                this.field_70235_a.func_70691_i(5.0f);
                            } else {
                                this.func_174815_a(this.field_70235_a, movingObject.field_72308_g);
                            }
                        }
                    } else if (this.field_70235_a.func_70652_k(movingObject.field_72308_g)) {
                        if (!movingObject.field_72308_g.func_70089_S()) {
                            this.field_70235_a.func_70691_i(25.0f);
                        } else {
                            this.func_174815_a(this.field_70235_a, movingObject.field_72308_g);
                        }
                    }
                    int b0 = 5;
                    if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                        b0 = 20;
                    } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        b0 = 60;
                    }
                    if (b0 > 0) {
                        ((EntityLivingBase)movingObject.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 20 * b0, 0 + this.field_70170_p.func_175659_aa().func_151525_a()));
                        ((EntityLivingBase)movingObject.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76419_f, 20 * b0, 0 + this.field_70170_p.func_175659_aa().func_151525_a()));
                        ((EntityLivingBase)movingObject.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20 * b0, 0 + this.field_70170_p.func_175659_aa().func_151525_a()));
                        ((EntityLivingBase)movingObject.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_82731_v, Integer.MAX_VALUE, 3));
                    }
                } else {
                    movingObject.field_72308_g.func_70097_a(DamageSource.field_76376_m, 5.0f);
                }
            }
            if (this.field_70235_a != null && this.field_70235_a instanceof EntityWitherStormHead) {
                this.field_70170_p.func_72885_a((Entity)this.field_70235_a, this.field_70165_t, this.field_70163_u, this.field_70161_v, 6.0f, true, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            } else {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.5f, true, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            }
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(INVULNERABLE, (Object)false);
    }

    public boolean isInvulnerable() {
        return (Boolean)this.field_70180_af.func_187225_a(INVULNERABLE);
    }

    public void setInvulnerable(boolean invulnerable) {
        this.field_70180_af.func_187227_b(INVULNERABLE, (Object)invulnerable);
    }

    protected boolean func_184564_k() {
        return false;
    }
}

