/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5.dragonphases;

import net.minecraft.entity.helpful.tier5.EntityEnderDragon;
import net.minecraft.entity.helpful.tier5.dragonphases.IPhase;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseList;

public class PhaseManager {
    private final EntityEnderDragon dragon;
    private final IPhase[] phases = new IPhase[PhaseList.getTotalPhases()];
    private IPhase phase;

    public PhaseManager(EntityEnderDragon dragonIn) {
        this.dragon = dragonIn;
        this.setPhase(PhaseList.HOVER);
    }

    public void setPhase(PhaseList<?> phaseIn) {
        if (this.phase == null || phaseIn != this.phase.getPhaseList()) {
            if (this.phase != null) {
                this.phase.removeAreaEffect();
            }
            this.phase = this.getPhase(phaseIn);
            if (!this.dragon.field_70170_p.field_72995_K) {
                this.dragon.func_184212_Q().func_187227_b(EntityEnderDragon.PHASE, (Object)phaseIn.getId());
            }
            this.phase.initPhase();
        }
    }

    public IPhase getCurrentPhase() {
        return this.phase;
    }

    public <T extends IPhase> T getPhase(PhaseList<T> phaseIn) {
        int i = phaseIn.getId();
        if (this.phases[i] == null) {
            this.phases[i] = phaseIn.createPhase(this.dragon);
        }
        return (T)this.phases[i];
    }
}

