/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumEntityTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.tier5.EntityWitherSkullOther;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EntityWither
extends EntityFriendlyCreature
implements IRangedAttackMob {
    private static final DataParameter<Integer> FIRST_HEAD_TARGET = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SECOND_HEAD_TARGET = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THIRD_HEAD_TARGET = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer>[] HEAD_TARGETS = new DataParameter[]{FIRST_HEAD_TARGET, SECOND_HEAD_TARGET, THIRD_HEAD_TARGET};
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private float[] xRotationHeads = new float[2];
    private float[] yRotationHeads = new float[2];
    private float[] xRotOHeads = new float[2];
    private float[] yRotOHeads = new float[2];
    private int[] nextHeadUpdate = new int[2];
    private int[] idleHeadUpdates = new int[2];
    private int blockBreakCounter;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityWither(World worldIn) {
        super(worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(1.0f, 3.5f);
        this.isOffensive = true;
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 3.0, 48.0f, 16.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 40, 20.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAILeaderHurtTarget(this));
        this.field_70728_aV = 50;
    }

    @Override
    public EnumEntityTier getTier() {
        return EnumEntityTier.TIER5;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRST_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(SECOND_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(THIRD_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(50) == 0 && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Invul", this.getInvulTime());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187925_gy;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187851_gB;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    public float func_70047_e() {
        return this.func_70093_af() ? 1.75f : 2.75f;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.945;
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        return entity instanceof EntityPlayer;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            int i;
            if (this.getInvulTime() > 0) {
                int i2 = this.getInvulTime() - 1;
                if (i2 <= 0) {
                    this.field_70170_p.func_72885_a((Entity)(!this.isWild() ? this.getOwner() : this), this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, this.isHero() ? 35.0f : 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)this), 0);
                }
                this.setInvulTime(i2);
                if (this.field_70173_aa % 1 == 0) {
                    this.func_70691_i(1.0f);
                }
            }
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            this.field_70747_aH = 0.2f;
            if (((EntityLivingBase)this.func_184179_bs()).field_70702_br != 0.0f && this.field_70173_aa % 10 == 0 && !this.field_70170_p.field_72995_K) {
                float f = this.field_70759_as * (float)Math.PI / 180.0f;
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                this.launchWitherSkullToCoords(0, this.field_70165_t - (double)(f1 * 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(f2 * 2.0f), this.field_70146_Z.nextFloat() < 0.001f);
            }
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            }
            this.field_184618_aE = this.field_70721_aZ;
            for (i = 0; i < 256; ++i) {
                int k;
                int j;
                int in = MathHelper.func_76128_c((double)(this.field_70165_t - 1.5 + this.field_70146_Z.nextDouble() * 3.0));
                BlockPos blockpos = new BlockPos(in, j = MathHelper.func_76128_c((double)(this.field_70163_u + 3.0 - this.field_70146_Z.nextDouble() * 8.0)), k = MathHelper.func_76128_c((double)(this.field_70161_v - 1.5 + this.field_70146_Z.nextDouble() * 3.0)));
                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (block == Blocks.field_150350_a) continue;
                this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.01, this.field_70161_v);
            }
            if (Keyboard.isKeyDown((int)57)) {
                this.field_70181_x = entitylivingbase.func_70051_ag() ? 0.75 : 0.5;
            }
            for (i = 1; i < 3; ++i) {
                int i1;
                if (this.field_70170_p.field_72995_K || this.field_70173_aa < this.nextHeadUpdate[i - 1]) continue;
                this.nextHeadUpdate[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    int k2 = i - 1;
                    int l2 = this.idleHeadUpdates[i - 1];
                    this.idleHeadUpdates[k2] = this.idleHeadUpdates[i - 1] + 1;
                    if (l2 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[i - 1] = 0;
                    }
                }
                if ((i1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(i1);
                    if (!this.func_70093_af() && entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 900.0 && this.func_70685_l(entity)) {
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                        this.idleHeadUpdates[i - 1] = 0;
                        if (this.moralRaisedTimer > 200) {
                            this.nextHeadUpdate[i - 1] = this.field_70173_aa + 20 + this.field_70146_Z.nextInt(10);
                            continue;
                        }
                        this.nextHeadUpdate[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                        continue;
                    }
                    this.updateWatchedTargetId(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                for (int k1 = 0; k1 < 10 && !list.isEmpty(); ++k1) {
                    EntityLivingBase entitylivingbase1 = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase1 != this && entitylivingbase1.func_70089_S() && this.func_70685_l((Entity)entitylivingbase1) && !this.isOnSameTeam(entitylivingbase1) && entitylivingbase1 != this.getOwner()) {
                        if (entitylivingbase1 instanceof EntityPlayer) {
                            if (!((EntityPlayer)entitylivingbase1).field_71075_bZ.field_75102_a) {
                                this.updateWatchedTargetId(i, entitylivingbase1.func_145782_y());
                            }
                        } else {
                            this.updateWatchedTargetId(i, entitylivingbase1.func_145782_y());
                        }
                    }
                    if (entitylivingbase1 != this && entitylivingbase1.func_70089_S() && this.func_70685_l((Entity)entitylivingbase1) && !this.isOnSameTeam(entitylivingbase1) && entitylivingbase1 != this.getOwner()) continue;
                    list.remove(entitylivingbase1);
                }
            }
        } else {
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    public void performSpecialAttack() {
        this.func_70642_aH();
        this.func_184185_a(ModSoundEvents.witherSpecial, 10.0f, 1.0f);
        this.setSpecialAttackTimer(1600);
    }

    @Override
    public void func_70636_d() {
        int j;
        int i;
        double d5;
        double d3;
        double d1;
        Entity entity;
        if (this.isWild()) {
            this.bossInfo.func_186745_a(BossInfo.Color.PURPLE);
        } else {
            this.bossInfo.func_186745_a(BossInfo.Color.BLUE);
        }
        if (this.func_70093_af()) {
            this.func_70105_a(1.0f, 2.3f);
        } else {
            this.func_70105_a(1.0f, 3.3f);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.func_70093_af()) {
            this.func_70624_b(null);
        }
        if (this.field_70163_u < 0.0) {
            this.field_70181_x += (0.5 - this.field_70181_x) * (double)0.6f;
        }
        if (this.getOwner() != null && this.func_70068_e((Entity)this.getOwner()) > 900.0 && this.func_70638_az() == null) {
            this.updateWatchedTargetId(0, this.getOwner().func_145782_y());
        }
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && this.getInvulTime() <= 0 && this.func_184179_bs() == null && !(this.func_184179_bs() instanceof EntityPlayer) && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            if (this.field_70163_u < entity.field_70163_u || !this.isArmored() && this.field_70163_u < entity.field_70163_u + 5.0 + (double)entity.func_70047_e()) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70122_E = false;
                this.field_70160_al = true;
                this.field_70181_x += 0.5 - this.field_70181_x;
            }
            this.func_70625_a(entity, 180.0f, 40.0f);
            double d0 = entity.field_70165_t - this.field_70165_t;
            d1 = entity.field_70161_v - this.field_70161_v;
            d3 = d0 * d0 + d1 * d1;
            if (d3 > 9.0) {
                if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y != 0.0) {
                    this.field_70177_z = this.field_70759_as = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
                    this.field_70761_aq = this.field_70759_as;
                }
                d5 = MathHelper.func_76133_a((double)d3);
                if (this.moralRaisedTimer > 200) {
                    this.field_70159_w += d0 / d5 * 0.75 - this.field_70159_w;
                    this.field_70179_y += d1 / d5 * 0.75 - this.field_70179_y;
                } else {
                    this.field_70159_w += d0 / d5 * 0.5 - this.field_70159_w;
                    this.field_70179_y += d1 / d5 * 0.5 - this.field_70179_y;
                }
            }
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotationHeads[i];
            this.xRotOHeads[i] = this.xRotationHeads[i];
        }
        for (i = 0; i < 2; ++i) {
            int j2 = this.getWatchedTargetId(i + 1);
            Entity entity1 = null;
            if (j2 > 0) {
                entity1 = this.field_70170_p.func_73045_a(j2);
            }
            if (entity1 != null) {
                d1 = this.func_82214_u(i + 1);
                d3 = this.func_82208_v(i + 1);
                d5 = this.func_82213_w(i + 1);
                double d6 = entity1.field_70165_t - d1;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d3;
                double d8 = entity1.field_70161_v - d5;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(Math.atan2(d8, d6) * 180.0 / Math.PI) - 90.0f;
                float f1 = (float)(-(Math.atan2(d7, d9) * 180.0 / Math.PI));
                this.xRotationHeads[i] = this.func_82204_b(this.xRotationHeads[i], f1, 40.0f);
                this.yRotationHeads[i] = this.func_82204_b(this.yRotationHeads[i], f, 10.0f);
                continue;
            }
            this.yRotationHeads[i] = this.func_82204_b(this.yRotationHeads[i], this.field_70761_aq, 10.0f);
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 512.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.isHero() && this.getSpecialAttackTimer() == 1400) {
            this.field_70170_p.func_72885_a((Entity)(!this.isWild() ? this.getOwner() : this), this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, false);
            this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)this), 0);
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(128.0, 128.0, 128.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity2 = (EntityLivingBase)list.get(i1);
                    if (entity2 == null) continue;
                    if (!this.isOnSameTeam(entity2) && entity2.func_184222_aU() && !(entity2 instanceof EntityFriendlyCreature)) {
                        entity2.field_70172_ad = 0;
                        entity2.func_70097_a(DamageSource.field_76377_j, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_82728_o, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_76367_g, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_188407_q, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_76369_e, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_76379_h, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_82729_p, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_188406_j, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_76372_a, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_76368_d, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_76371_c, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_180137_b, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_76376_m, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_76370_b, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_76366_f, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.field_82727_n, Float.MAX_VALUE);
                        entity2.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entity2), Float.MAX_VALUE);
                        if (entity2.func_70089_S() || this.isWild()) continue;
                        entity2.func_70106_y();
                        this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity2.func_70005_c_() + " doesn't exist anymore...", new Object[0]));
                        continue;
                    }
                    list.remove(entity2);
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.isHero() && this.getSpecialAttackTimer() >= 1400) {
                for (int i1 = 0; i1 < 128; ++i1) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + 1.75, this.field_70161_v, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, new int[0]);
                }
            }
        }
        boolean flag = this.isArmored();
        for (j = 0; j < 3; ++j) {
            double d10 = this.func_82214_u(j);
            double d2 = this.func_82208_v(j);
            double d4 = this.func_82213_w(j);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0, new int[0]);
            if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5, new int[0]);
        }
        if (this.getInvulTime() > 0) {
            for (j = 0; j < 3; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 1.0, (double)0.7f, (double)0.7f, (double)0.9f, new int[0]);
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_72885_a((Entity)(!this.isWild() ? this.getOwner() : this), this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, this.isHero() ? 35.0f : 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 1 == 0) {
                this.func_70691_i(1.0f);
            }
        } else {
            super.func_70619_bc();
            for (int i = 1; i < 3; ++i) {
                int i1;
                if (this.field_70173_aa < this.nextHeadUpdate[i - 1]) continue;
                this.nextHeadUpdate[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    int k2 = i - 1;
                    int l2 = this.idleHeadUpdates[i - 1];
                    this.idleHeadUpdates[k2] = this.idleHeadUpdates[i - 1] + 1;
                    if (l2 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[i - 1] = 0;
                    }
                }
                if ((i1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(i1);
                    if (!this.func_70093_af() && entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 900.0 && this.func_70685_l(entity)) {
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                        this.idleHeadUpdates[i - 1] = 0;
                        if (this.moralRaisedTimer > 200) {
                            this.nextHeadUpdate[i - 1] = this.field_70173_aa + 20 + this.field_70146_Z.nextInt(10);
                            continue;
                        }
                        this.nextHeadUpdate[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                        continue;
                    }
                    this.updateWatchedTargetId(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                for (int k1 = 0; k1 < 10 && !list.isEmpty(); ++k1) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase) && !this.isOnSameTeam(entitylivingbase) && entitylivingbase != this.getOwner()) {
                        if (entitylivingbase instanceof EntityPlayer) {
                            if (!((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                                this.updateWatchedTargetId(i, entitylivingbase.func_145782_y());
                            }
                        } else {
                            this.updateWatchedTargetId(i, entitylivingbase.func_145782_y());
                        }
                    }
                    if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase) && !this.isOnSameTeam(entitylivingbase) && entitylivingbase != this.getOwner()) continue;
                    list.remove(entitylivingbase);
                }
            }
            if (this.func_70638_az() != null) {
                this.updateWatchedTargetId(0, this.func_70638_az().func_145782_y());
            } else {
                this.updateWatchedTargetId(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    int i11 = MathHelper.func_76128_c((double)this.field_70163_u);
                    int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            for (int j = 0; j <= 3; ++j) {
                                int i3 = l1 + k2;
                                int k = i11 + j;
                                int l = i2 + l2;
                                BlockPos blockpos = new BlockPos(i3, k, l);
                                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                                Block block = iblockstate.func_177230_c();
                                if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this)) continue;
                                flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a((EntityPlayer)null, 1022, new BlockPos((Entity)this), 0);
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
                if (this.func_70093_af()) {
                    this.bossInfo.func_186758_d(false);
                } else if (this.func_70089_S()) {
                    this.bossInfo.func_186758_d(true);
                }
            }
        }
    }

    public static boolean canDestroyBlock(Block p_181033_0_) {
        return p_181033_0_ != Blocks.field_150357_h && p_181033_0_ != Blocks.field_150384_bq && p_181033_0_ != Blocks.field_150378_br && p_181033_0_ != Blocks.field_150483_bI && p_181033_0_ != Blocks.field_185776_dc && p_181033_0_ != Blocks.field_185777_dd && p_181033_0_ != Blocks.field_180401_cv;
    }

    public void func_82206_m() {
        this.setInvulTime(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_70110_aj() {
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.25;
    }

    private double func_82208_v(int p_82208_1_) {
        return this.func_70093_af() ? this.field_70163_u + 1.25 : this.field_70163_u + 2.25;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        if (!(stack != null || this.field_70170_p.field_72995_K || this.isWild() || player != this.getOwner() && !player.func_184191_r((Entity)this))) {
            player.func_184220_m((Entity)this);
            ForgeHooks.onLivingJump((EntityLivingBase)this);
            return true;
        }
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.25;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_, boolean p_82209_8_) {
        float f;
        this.func_184185_a(SoundEvents.field_187853_gC, this.func_70599_aP(), 1.0f);
        double d3 = this.func_82214_u(p_82209_1_);
        double d4 = this.func_82208_v(p_82209_1_);
        double d5 = this.func_82213_w(p_82209_1_);
        double d6 = p_82209_2_ - d3;
        double d7 = p_82209_4_ - d4;
        double d8 = p_82209_6_ - d5;
        EntityWitherSkullOther entitywitherskull = new EntityWitherSkullOther(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
        if (p_82209_8_) {
            entitywitherskull.func_82343_e(true);
        }
        entitywitherskull.damage = f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        entitywitherskull.field_70163_u = d4;
        entitywitherskull.field_70165_t = d3;
        entitywitherskull.field_70161_v = d5;
        this.field_70170_p.func_72838_d((Entity)entitywitherskull);
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        if (!this.isOnSameTeam(p_82196_1_)) {
            this.launchWitherSkullToEntity(0, p_82196_1_);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!source.func_94541_c() && source != DamageSource.field_76369_e) {
            Entity entity;
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.isArmored() && (entity = source.func_76364_f()) instanceof EntityArrow) {
                return false;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.idleHeadUpdates.length) {
                int n = i++;
                this.idleHeadUpdates[n] = this.idleHeadUpdates[n] + 10;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        EntityItem entityitem = this.func_145779_a(Items.field_151156_bN, 1);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_187977_J);
            }
        }
    }

    @Override
    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : 2.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect p_70690_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.yRotationHeads[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.xRotationHeads[p_82210_1_];
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)p_82215_1_);
    }

    public int getWatchedTargetId(int p_82203_1_) {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_TARGETS[p_82203_1_]);
    }

    public void updateWatchedTargetId(int targetOffset, int newId) {
        this.field_70180_af.func_187227_b(HEAD_TARGETS[targetOffset], (Object)newId);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public boolean func_70662_br() {
        return true;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.woodHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.woodHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.woodHitCrush;
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityWither.this.getInvulTime() > 0;
        }
    }
}

